//************************************************************
// config.C - configuration classes for the spk client/server
//  Author Eugene Anikin     anikin@anikin.ddns.org
//************************************************************

#include "incall.h"

ConfigInfo::ConfigInfo()
{
      SerialPort = new char[20];
      strcpy(SerialPort, "/dev/ttyS0");

      CommandSet = new char[20];
      strcpy(CommandSet, "/etc/spk/spk.cmds");

      FirstActionFile = new char[20];
      strcpy(FirstActionFile, "/etc/spk/actions");

      GSPKPath = new char[26];
      strcpy(GSPKPath, "/usr/local/lib/spk/gspk");

      Counter = new char[20];
      strcpy(Counter, "/etc/spk/.spkcount");

      DefPath = new char[32];
      strcpy(DefPath, "/home/anikin/.vmbox");

      LockPath = new char[20];
      strcpy(LockPath, "/var/lock");

      RunPath = new char[20];
      strcpy(RunPath, "/var/run/spk");

      CheckGSM = 1;
      TestLocal = 0;
      PortSpeed = 38400;
      UseCallerID = 1;
      SpkCapable = 1;
};

ConfigInfo::ConfigInfo(ConfigInfo* con)
{
      if (con == NULL) return;

      SerialPort = new char[1+strlen(con->SerialPort)];
      strcpy(SerialPort, con->SerialPort);

      CommandSet = new char[1+strlen(con->CommandSet)];
      strcpy(CommandSet, con->CommandSet);

      FirstActionFile = new char[1+strlen(con->FirstActionFile)];
      strcpy(FirstActionFile, con->FirstActionFile);

      GSPKPath = new char[1+strlen(con->GSPKPath)];
      strcpy(GSPKPath, con->GSPKPath);

      Counter = new char[1+strlen(con->Counter)];
      strcpy(Counter, con->Counter);

      DefPath = new char[1+strlen(con->DefPath)];
      strcpy(DefPath, con->DefPath);

      LockPath = new char[1+strlen(con->LockPath)];
      strcpy(LockPath, con->LockPath);

      RunPath = new char[1+strlen(con->RunPath)];
      strcpy(RunPath, con->RunPath);

      CheckGSM = con->CheckGSM;
      TestLocal = con->TestLocal;
      PortSpeed = con->PortSpeed;
      UseCallerID = con->UseCallerID;
      SpkCapable = con->SpkCapable;
};

ConfigInfo::~ConfigInfo()
{
      delete SerialPort;
      delete CommandSet;      
      delete FirstActionFile; 
      delete GSPKPath; 

      delete Counter;
      delete DefPath;
      delete LockPath;   
      delete RunPath;    
};

void ConfigInfo::ReadConfig(char* FName)
{
   FILE* fp;
   char buf[1024];
   char buf1[1024];

   fp = fopen(FName, "r");
   if (fp == NULL)
   {
      syslog(LOG_ERR, "Unable to open %s for reading", FName);
      return;
   }

   while(fgets(buf, sizeof(buf), fp))
   {
      buf[1023]=0; // Terminate the string
      if (1==sscanf(buf, "SERIAL_PORT=%s", buf1)) {
         delete SerialPort;
         SerialPort=new char[1+strlen(buf1)];
         strcpy(SerialPort,buf1);
         continue;
      }
      
      if (1==sscanf(buf, "COMMAND_SET=%s", buf1)) {
         delete CommandSet;
         CommandSet=new char[1+strlen(buf1)];
         strcpy(CommandSet,buf1);
         continue;
      }

      if (1==sscanf(buf, "FIRST_ACTION_FILE=%s", buf1)) {
         delete FirstActionFile;
         FirstActionFile=new char[1+strlen(buf1)];
         strcpy(FirstActionFile,buf1);
         continue;
      }

      if (1==sscanf(buf, "GSPK_LOCATION=%s", buf1)) {
         delete GSPKPath;
         GSPKPath=new char[1+strlen(buf1)];
         strcpy(GSPKPath,buf1);
         continue;
      }

      if (1==sscanf(buf, "COUNTER=%s", buf1)) {
         delete Counter;
         Counter=new char[1+strlen(buf1)];
         strcpy(Counter,buf1);
         continue;
      }

      if (1==sscanf(buf, "DEFAULT_PATH=%s", buf1)) {
         delete DefPath;
         DefPath=new char[1+strlen(buf1)];
         strcpy(DefPath,buf1);
         continue;
      }

      if (1==sscanf(buf, "LOCK_PATH=%s", buf1)) {
         delete LockPath;
         LockPath=new char[1+strlen(buf1)];
         strcpy(LockPath,buf1);
         continue;
      }

      if (1==sscanf(buf, "RUN_PATH=%s", buf1)) {
         delete RunPath;
         RunPath=new char[1+strlen(buf1)];
         strcpy(RunPath,buf1);
         continue;
      }
      if (1==sscanf(buf, "CHECK_GSM=%d", &CheckGSM ))
         continue;
      if (1==sscanf(buf, "TEST_LOCAL=%d", &TestLocal ))
         continue;
      if (1==sscanf(buf, "PORT_SPEED=%d", &PortSpeed ))
         continue;
      if (1==sscanf(buf, "USE_CALLER_ID=%d", &UseCallerID ))
         continue;
      if (1==sscanf(buf, "SPK_CAPABLE=%d", &SpkCapable ))
         continue;
   }

   fclose(fp);
};

void ConfigInfo::SaveConfig(char* FName)
{
   FILE* fp;

   fp = fopen(FName, "w");
   if (fp == NULL)
   {
      syslog(LOG_ERR, "Unable to open %s for writing", FName);
      return;
   }

   fprintf(fp,"SERIAL_PORT=%s\n", SerialPort);
   fprintf(fp,"COMMAND_SET=%s\n", CommandSet );
   fprintf(fp,"FIRST_ACTION_FILE=%s\n", FirstActionFile );
   fprintf(fp,"GSPK_LOCATION=%s\n", GSPKPath );
   fprintf(fp,"COUNTER=%s\n", Counter );
   fprintf(fp,"DEFAULT_PATH=%s\n", DefPath );
   fprintf(fp,"LOCK_PATH=%s\n", LockPath );
   fprintf(fp,"RUN_PATH=%s\n", RunPath );
   fprintf(fp,"CHECK_GSM=%d\n", CheckGSM );
   fprintf(fp,"TEST_LOCAL=%d\n", TestLocal );
   fprintf(fp,"PORT_SPEED=%d\n", PortSpeed );
   fprintf(fp,"USE_CALLER_ID=%d\n", UseCallerID );
   fprintf(fp,"SPK_CAPABLE=%d\n", SpkCapable );

   fflush(fp);
   fclose(fp);
};

char* ConfigInfo::CreateFullPath(char* FName)
{
   static char newName[1024];
   int len;
   
   if (FName[0] == '/') 
   {
      strncpy(newName, FName, 1023);
      newName[1023] = 0;
   } else
   {
      strncpy(newName, DefPath, 1023);
      newName[1023] = 0;
      len = strlen(newName);
      if (newName[len-1] != '/') newName[len++] = '/';

      strncpy(&(newName[len]), FName, 1023 - len);
   }
   return newName;
}

