#!/bin/bash

echo "** $* -MM -MG -xc" >&2

while read trg srclist; do
	echo -n "$trg"
	for src in $srclist; do
		case "$src" in
			spl_op.h|*.splh|spl_modules/*)
				echo -n " $src"
				;;
			*)
				[ -f "$src" ] && echo -n " $src"
				;;
		esac
	done
	echo
done < <(
	eval "$* -DMAKEDEPS -MM -MG -xc compiler.y *.c examples/*.c spl_modules/*.c" |
	sed "s|^mod_|spl_modules/mod_|; s|^c-api-test|examples/&|; s| $(pwd -P)/| |g;" |
	tr '\n' '|' | sed 's,\\| *,,g' | tr '|' '\n' | grep -v '^#' |
	egrep -v '^(moddir|moc_mod_qt)\.o:' | sed 's| \./| |g' | sed 's| /[^ ]*||g';
) > GNUmakefile.deps.new

echo 'spl_modules/mod_fann.o: spl_modules/mod_fann.c spl.h compat.h' >> GNUmakefile.deps.new
echo 'spl_modules/mod_gl.o: spl_modules/mod_gl.c spl.h compat.h' >> GNUmakefile.deps.new

if test -s GNUmakefile.deps.new; then
	LC_ALL="C" sort -u GNUmakefile.deps.new > GNUmakefile.deps
fi

rm -f GNUmakefile.deps.new

