// StarPlot - A program for interactively viewing 3D maps of stellar positions.
// Copyright (C) 2000  Kevin B. McCarty
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
/*
  menu.h
  This file contains definitions for the StarPlot menu system,
  declarations for menu callback functions, and arrays of menu widget
  pointers.
*/

#ifndef _STARPLOT_MENU_H
#define _STARPLOT_MENU_H

// for shortening line length:
#define STO "<StockItem>"
#define CHE "<CheckItem>"
#define RAD "<RadioItem>"


/* GtkItemFactoryEntry menu format:

                      accelerator       callback   fn.    menu item  extra
     menu path                key       function   param  type       data
*/

// note: use of a stock item also sets the accelerator key unless it's
// specifically set to the null string (NOT the null pointer)

#define FILE_MENU \
{ \
  _("/_File"),                   0,      0,            0, "<Branch>" },        \
{ _("/File/_Open Star Database..."), "", file_open,    0, STO,	"gtk-open" }, \
{ _("/File/_Merge Star Database..."), "",file_merge,   0, STO,   "gtk-open" }, \
{ _("/File/-----"),              0,     0,             0, "<Separator>" },     \
{ _("/File/Open _Parameter File..."),"", params_open,  0, STO,   "gtk-open" }, \
{ _("/File/Save _Chart Parameters..."),"",params_save, 0, STO,   "gtk-save" }, \
{ _("/File/-----"),              0,     0,             0, "<Separator>" }, \
{ _("/File/_Save Chart as PNG..."),   0, file_save,    0, STO,	"gtk-save" }, \
{ _("/File/-----"),              0,     0,             0, "<Separator>" },     \
{ _("/File/_Quit"),              "",    starplot_quit, 0, STO,   "gtk-quit" }

// defined in filedialogs.cc:
extern void starplot_quit();
extern void file_open();
extern void file_merge();
extern void params_open();
extern void params_save();
extern void file_save();


#define CHART_MENU \
{ _("/_Chart"),                  0,     0,             0, "<Branch>" },        \
{ _("/Chart/_Define Chart..."),  0,     chart_define,  0, "" },                \
{ _("/Chart/_Orientation..."),   0,     chart_orient,  0, "" },                \
{ _("/Chart/Star _Filter..."),   0,     chart_filter,  0, "" }

// defined in chartdialogs.cc:
extern void chart_define();
extern void chart_orient();
extern void chart_filter();


#define OPTIONS_CUSTOM_MENU \
{ _("/_Options"),            0,	0,             0, "<Branch>" },   \
\
/* \
{ _("/Options/C_olors..."),  0,	custom_colors, 0, STO, "gtk-select-color" }, \
*/ \
\
{ _("/Options/_Font..."),    0, custom_font,   0, STO, "gtk-select-font" },   \
{ _("/Options/-----"),	     0,	0,	       0, "<Separator>" }

// defined in custom.cc:
extern void custom_colors();
extern void custom_font();


#define OPTIONS_TOGGLE_MENU_SIZE 3
extern GtkWidget *options_toggle_widgets[OPTIONS_TOGGLE_MENU_SIZE];
#define OPTIONS_TOGGLE_MENU \
{ _("/Options/Toggle _Bars"),  "<control>B", toggle_bars,   0, CHE },          \
{ _("/Options/Toggle G_rid"),  "<control>R", toggle_grid,   0, CHE },          \
{ _("/Options/Toggle _Legend"),"<control>L", toggle_legend, 0, CHE },	      \
{ _("/Options/-----"),           0,          0,		   0, "<Separator>" }

#define TOGGLE_BARS   0
#define TOGGLE_GRID   1
#define TOGGLE_LEGEND 2

// defined in menuops.cc:
extern void toggle_bars();
extern void toggle_grid();
extern void toggle_legend();


#define OPTIONS_LABEL_MENU_SIZE 4
extern GtkWidget *options_label_widgets[OPTIONS_LABEL_MENU_SIZE];
extern GtkWidget *hr_options_label_widgets[OPTIONS_LABEL_MENU_SIZE];
extern char options_label_names[OPTIONS_LABEL_MENU_SIZE][100];
#define OPTIONS_LABEL_MENU \
{ _("/Options/_Star Labels"), 0, 0,   0, "<Branch>" },                        \
{ _("/Options/Star Labels/Landmar_k Stars"),                                  \
    "<control>K", labels_landmk,   0, "<RadioItem>" },                        \
{ _("/Options/Star Labels/All Star _Names"),                                  \
  "<control>N", labels_all,      0, _("/Options/Star Labels/Landmark Stars") },\
{ _("/Options/Star Labels/Numerical _Index"),                                 \
  "<control>I", labels_numerical,0, _("/Options/Star Labels/Landmark Stars") },\
{ _("/Options/Star Labels/Labels _Off"),                                      \
  "<control>O", labels_off,      0, _("/Options/Star Labels/Landmark Stars") }

// defined in menuops.cc:
extern void labels_all();
extern void labels_landmk();
extern void labels_off();
extern void labels_numerical();


#define OPTIONS_DIAMETER_MENU_SIZE 2
extern GtkWidget *options_diameter_widgets[OPTIONS_DIAMETER_MENU_SIZE];
extern GtkWidget *hr_options_diameter_widgets[OPTIONS_DIAMETER_MENU_SIZE];
extern char options_diameter_names[OPTIONS_DIAMETER_MENU_SIZE][100];
#define OPTIONS_DIAMETER_MENU \
{ _("/Options/Star _Diameters"), 0, 0, 0, "<Branch>" },                       \
{ _("/Options/Star Diameters/By _Magnitude"),                                 \
    0, mag_diameters, 0, "<RadioItem>" },                                     \
{ _("/Options/Star Diameters/By M_K Class"),                                  \
    0, mk_diameters,  0, _("/Options/Star Diameters/By Magnitude") }

// defined in menuops.cc:
extern void mk_diameters();
extern void mag_diameters();


#define OPTIONS_COORD_MENU_SIZE 2
extern GtkWidget *options_coord_widgets[OPTIONS_COORD_MENU_SIZE];
#define OPTIONS_COORD_MENU \
{ _("/Options/_Coordinate System"),  0,      0,          0, "<Branch>" },   \
{ _("/Options/Coordinate System/_Celestial"),                               \
  "<control>C", cel_coords,       0, "<RadioItem>" },                       \
{ _("/Options/Coordinate System/_Galactic"),                                \
    "<control>G", gal_coords,     0, _("/Options/Coordinate System/Celestial")}

// defined in menuops.cc:
extern void cel_coords();
extern void gal_coords();


#define STARS_MENU \
{ _("/_Stars"),                  0,          0,          0, "<Branch>" },      \
{ _("/Stars/Chart _Data..."),  "<control>D", starinfo,   0, "" },              \
{ _("/Stars/_HR Diagram..."),  "<control>H", hrdiagram,  0, "" },              \
{ _("/Stars/_Search..."),      "<control>S", starsearch, 0, STO,  "gtk-find" }

// defined in infodialogs.cc:
extern void starinfo();
extern void starsearch();
// defined in hrdiagram.cc:
extern void hrdiagram();

#ifndef BROWSER
# define HELP_MENU \
{ _("/_Help"),                   0,          0,          0, "<LastBranch>" },  \
{ _("/Help/_Select Help Browser..."), "",    help_select,0, "" },              \
{ _("/Help/_Documentation..."),  "",         helpdocs,   0, STO, "gtk-help" }, \
{ _("/Help/StarPlot _Web Page..."), "",      webpage,    0, STO, "gtk-home" }, \
{ _("/Help/-----"),              0,	     0,          0, "<Separator>" },   \
{ _("/Help/_About..."),          "",         abouthelp,  0, STO, "gtk-help" }

#else
# define HELP_MENU \
{ _("/_Help"),                   0,          0,          0, "<LastBranch>" },  \
{ _("/Help/_Documentation..."),  "",         helpdocs,   0, STO, "gtk-help" }, \
{ _("/Help/StarPlot _Web Page..."), "",      webpage,    0, STO, "gtk-home" }, \
{ _("/Help/-----"),              0,	     0,          0, "<Separator>" },   \
{ _("/Help/_About..."),          "",         abouthelp,  0, STO, "gtk-help" }

#endif

// defined in filedialogs.cc:
extern void help_select();
// defined in menuops.cc:
extern void helpdocs();
extern void webpage();
extern void abouthelp();


#endif // #define _STARPLOT_MENU_H
