/* Copyright (C) 2000-2006  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: users.pike,v 1.7 2006/09/27 20:27:27 astra Exp $
 */

constant cvs_version="$Id: users.pike,v 1.7 2006/09/27 20:27:27 astra Exp $";

inherit "/kernel/secure_mapping.pike";

#include <macros.h>
#include <database.h>
#include <classes.h>
#include <attributes.h>

//! This module keeps track of the users in the database. -
//! Therefor it maps a nickname to the related sTeam user object.

private static function             myfDb;
private static string          mysDbTable;

void load_module() 
{
  ::load_module();
  [myfDb , mysDbTable] = _Database->connect_db_mapping();
  if( search(myfDb()->list_tables(), "i_userlookup" ) == -1 ) {
    MESSAGE("Creating i_userlookup table in users module.");
    mixed err = catch {
      myfDb()->big_query("create table i_userlookup "
			 "(login char(255) not null, email char(255), firstname char(255), lastname char(255), id char(255), oid char(255) not null, UNIQUE(oid))");
      
      foreach( get_users(), object u) {
	update_user(u);
      }
    };
    if ( err != 0 ) 
      FATAL("Failed to create userlookup table: %O\n%O", err[0],err[1]);
  }
}

void update_user(object u) 
{
  if ( objectp(u) ) {
    Sql.sql_result res = myfDb()->big_query("select * from i_userlookup where oid='"+u->get_object_id()+"'");
    mixed err = catch {
      string query;
      if ( res->fetch_row() ) {
	query = sprintf("update i_userlookup set login='%s',email='%s',firstname='%s',lastname='%s',id='%s' where oid='%s'",
			myfDb()->quote(u->get_user_name()||""),
			myfDb()->quote(u->query_attribute(USER_EMAIL)||""),
			myfDb()->quote(u->query_attribute(USER_FIRSTNAME)||""),
			myfDb()->quote(u->query_attribute(USER_FULLNAME)||""),
			myfDb()->quote(u->query_attribute(USER_ID)||""), 
			(string)u->get_object_id());
      }
      else {
	query = 
	  sprintf("insert into i_userlookup values('%s','%s','%s','%s','%s','%s')",
		  myfDb()->quote(u->get_user_name()||""),
		  myfDb()->quote(u->query_attribute(USER_EMAIL)||""),
		  myfDb()->quote(u->query_attribute(USER_FIRSTNAME)||""),
		  myfDb()->quote(u->query_attribute(USER_FULLNAME)||""),
		  myfDb()->quote(u->query_attribute(USER_ID)||""), 
		  (string)u->get_object_id());
      }      
      myfDb()->big_query(query);
    };
    if ( err ) {
      FATAL("Failed to insert user: %O\n%O", err[0], err[1]);
    }
  }  
}

int register(string uname, object key) 
{
  mixed err = catch(update_user(key));
  if ( err ) 
    FATAL("While updating user: %O\n%O", err[0], err[1]);

  return ::register(uname, key);
}

static object check_user(int id) 
{
  // check if user data are still ok ?!
  object user = find_object(id);
  return user;
}

/**
 * Lookup a user by his name (firstname, lastname)
 *
 * @param string firstname the firstname of the user to search
 * @param string lastname the last name of the user to search
 * @param bool like optional parameter to specify "like" instead of "="
 * @return array of matching users
 */
array(object) lookup_name(string firstname, string lastname, void|bool like)
{
  string eq = "=";
  if ( like ) eq = "like";

  Sql.sql_result res = myfDb()->big_query("select oid from i_userlookup where firstname "+eq+" '"+firstname +"' and lastname " + eq + " '"+lastname+"'");
  mixed row;

  if ( !objectp(res) )
    return 0;
 
  array result = ({ });
  while ( row = res->fetch_row() ) {
    result += ({ check_user((int)row[0]) });
  }
  destruct(res);
  return result;
}

/**
 * Lookup a user by his lastname
 *
 * @param string lastname the last name of the user to search
 * @return array of matching users
 */
array(object) lookup_lastname(string lastname, void|bool like)
{
  string eq = "=";
  if ( like ) eq = "like";
  Sql.sql_result res = myfDb()->big_query("select oid from i_userlookup where lastname "+eq+" '"+lastname+"'");
  mixed row;

  if ( !objectp(res) )
    return 0;
 
  array result = ({ });
  while ( row = res->fetch_row() ) {
    result += ({ check_user((int)row[0]) });
  }
  destruct(res);
  return result;
}

/**
 * Lookup a user by his first name
 *
 * @param string firstname the first name of the user to search
 * @return array of matching users
 */
array(object) lookup_firstname(string firstname, void|bool like)
{
  string eq = "=";
  if ( like ) eq = "like";
  Sql.sql_result res = myfDb()->big_query("select oid from i_userlookup where firstname "+eq+" '"+firstname+"'");
  mixed row;

  if ( !objectp(res) )
    return 0;
 
  array result = ({ });
  while ( row = res->fetch_row() ) {
    result += ({ check_user((int)row[0]) });
  }
  destruct(res);
  return result;
}

/**
 * Search users by a term
 *
 * @param string term the search term 
 * @return array of matching users
 */
array(object) search_users(string term, void|bool like)
{
  string eq = " = ";
  if ( like ) eq = " like ";
  term = "'" + myfDb()->quote(term) + "'";
  Sql.sql_result res = myfDb()->big_query("select distinct oid from i_userlookup where firstname "+eq + term+" or lastname "+ eq +term+" or email "+eq+term +" or id "+eq+term + " or login " + eq + term);
  mixed row;

  if ( !objectp(res) )
    return 0;
 
  array result = ({ });
  while ( row = res->fetch_row() ) {
    result += ({ check_user((int)row[0]) });
  }
  destruct(res);
  return result;
}

/**
 * Lookup a user by id
 *
 * @param string id the id to lookup
 * @return array of matching users
 */
array(object) lookup_id(string id) 
{
  Sql.sql_result res = myfDb()->big_query("select oid from i_userlookup where id='"+id+"'");
  mixed row;

  if ( !objectp(res) )
    return 0;
 
  array result = ({ });
  while ( row = res->fetch_row() ) {
    result += ({ check_user((int)row[0]) });
  }
  destruct(res);
  return result;
}

/**
 * Lookup a user by e-amil
 *
 * @param string e-mail the e-mail to lookup
 * @param bool like exact search flag
 * @return array of matching users
 */
array(object) lookup_email(string email, void|bool like) 
{
  string eq = "=";
  if ( like ) eq = "like";

  Sql.sql_result res = myfDb()->big_query("select oid from i_userlookup where email " + eq + " '"+email+"'");
  mixed row;

  if ( !objectp(res) )
    return 0;
 
  array result = ({ });
  while ( row = res->fetch_row() ) {
    result += ({ check_user((int)row[0]) });
  }
  destruct(res);
  return result;
}

/**
 * Lookup a user by login
 *
 * @param string index the login to lookup
 * @return matching user
 */
object lookup(string index)
{
  object user = ::lookup(index);
  if ( !objectp(user) )
    return _Persistence->lookup_user(index);
  return user;
}

string rename_user(object user, string new_name)
{
  if ( CALLER != get_factory(CLASS_USER) )
    steam_error("Invalid call to rename_user() !");
  object other = get_value(new_name);
  if ( objectp(other) && other != user )
    steam_error("There is already a user with the name '"+new_name+"' !");
  string name = user->get_user_name();
  set_value(name, 0);
  set_value(new_name, user);
  return new_name;
}

array(object) get_users() 
{
  array(string) index  = index();
  array(object) users =   ({ });

  foreach ( index, string idx ) {
    object obj = get_value(idx);
    if ( objectp(obj) )
      users += ({ obj });
  }
  return users;
}

object get_user(string name )
{
  return get_value(name);
}

string get_identifier() { return "users"; }
string get_table_name() { return "users"; }

