/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BLAMEDIALOG_H
#define _SC_BLAMEDIALOG_H

// sc
#include "sublib/TargetId.h"
#include "util/String.h"
class RevisionWidget;
class BaseModel;

namespace svn
{
  class Error;
}

// qt
#include <qwidget.h>
class QPushButton;
class QListView;

// sys
#include <vector>

/**
 * Dialog class for displaying blame information.
 */
class BlameDialog : public QWidget, public TargetId
{
  typedef QWidget super;
  Q_OBJECT 

public:
  BlameDialog( BaseModel* model, QWidget *parent = 0, const char *name=0 );
  virtual ~BlameDialog();

  void customEvent( QCustomEvent* ce );

  void setSource( const sc::String& source );

  void finished();

public slots:
  void run();

private:
  BaseModel*       _model;
  sc::String       _source;

  RevisionWidget*  _rwStart;
  RevisionWidget*  _rwStop;

  QListView*       _blame;

  QPushButton*     _run;
  QPushButton*     _done;
};

#endif // _SC_BLAMEDIALOG_H
