/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONFIGMANAGER_H
#define _SC_CONFIGMANAGER_H

//sc
#include "settings/ProjectSettings.h"
#include "settings/ToolsSettings.h"
#include "settings/FontSettings.h"
#include "settings/CommitLogHistory.h"
#include "settings/SubversionSettings.h"
#include "sublib/settings/ColorSettings.h"
#include "sublib/settings/LayoutSettings.h"
#include "sublib/DebugSettings.h"
class ConfigFile;
class ConfigData;


class ConfigManager :
  public ProjectSettings,
  public FontSettings,
  public ColorSettings,
  public LayoutSettings,
  public ToolsSettings,
  public CommitLogHistory,
  public SubversionSettings,
  public DebugSettings
{
public:
  ConfigManager();
  ~ConfigManager();

  void load();
  void save();

  /**
   * \name ProjectSettings.
   */
  // @{
  void getProjects( Projects& projects );
  void setProject( const Project* project );
  void removeProject( const Project* project );
  // @}

  /**
   * \name FontSettings.
   */
  // @{
  QFont getGeneralFont();
  void setGeneralFont( const QFont& );
  QFont getEditorFont();
  void setEditorFont( const QFont& );
  // @}

  /**
   * \name ColorSettings.
   */
  // @{
  void getColors( Colors& );
  void setColors( const Colors& );
  // @}

  /**
   * \name LayoutSettings.
   */
  // @{
  QRect getWindowRect( const QString& key, const QRect& def );
  void  setWindowRect( const QString& key, const QRect& rect );
  void getHeaderColumns( const QString& key, QHeader* );
  void setHeaderColumns( const QString& key, const QHeader* );
  int  getPosition( const QString& key );
  void setPosition( const QString& key, int pos );
  // @}

  /**
   * \name ToolsSettings.
   */
  // @{
  sc::String getBuiltinDiffCmd();
  sc::String getDiffCmd();
  void setDiffCmd( const sc::String& );
  sc::String getBuiltinMergeCmd();
  sc::String getMergeCmd();
  void setMergeCmd( const sc::String& );
  // @}

  /**
   * \name CommitLogHistory.
   */
  // @{
  void getLogs( Logs& logs );
  void addLog( const sc::String& );
  // @}

  /**
   * \name SubversionSettings.
   */
  // @{
  bool getAspDotNetHack();
  void setAspDotNetHack( bool enable );
  // @}

  /**
   * \name DebugSettings.
   */
  // @{
  bool getDump();
  void setDump(bool);
  bool getLog();
  void setLog(bool);
  bool getL10n();
  void setL10n(bool);
  // @}

  /**
   * \name Options.
   */
  // @{
  bool getOptCommandForce() const;
  void setOptCommandForce( bool );
  bool getOptCommandRecursive() const;
  void setOptCommandRecursive( bool );
  bool getOptStatusUpdates() const;
  void setOptStatusUpdates( bool );
  bool getOptStatusIgnored() const;
  void setOptStatusIgnored( bool );
  bool getOptStatusAll() const;
  void setOptStatusAll( bool );
  bool getOptStatusRecursive() const;
  void setOptStatusRecursive( bool );
  // @}

private:
  Color getColor( long id, const sc::String& name, const QColor& def, const sc::String& desc );
  
private:
  ConfigFile* _file;
  ConfigData* _cfg;

private:
  bool        _dbgDump;    // DebugSettings, not persistent
  bool        _dbgLog;     // DebugSettings, not persistent
};


#endif //  _SC_CONFIGMANAGER_H
