/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTFOLDERSWIDGET_H
#define _SC_PROJECTFOLDERSWIDGET_H

// sc
#include "sublib/TargetId.h"
#include "svn/DirEntryTypes.h"
#include "svn/WcStatusTypes.h"
#include "svn/Revision.h"
#include "util/String.h"
class RepositoryModel;  // todo: rename to RpModel
class RepositoryLvi;
class RevisionWidget;
class ActionStorage;
class WcModel;
class Project;

// qt
#include <qlistview.h>
class QPopupMenu;

class ProjectFoldersWidget : public QListView, public TargetId
{
  typedef QListView super;
  Q_OBJECT 

public:
  ProjectFoldersWidget( RepositoryModel* rmodel, WcModel* wmodel,
    QWidget *parent=0, const char *name=0 );
  virtual ~ProjectFoldersWidget();

  // QListView
  void customEvent( QCustomEvent* ce );
  QDragObject* dragObject();

  void refreshProjects();

  QPopupMenu* getWorkingCopyMenu();
  QPopupMenu* getRepositoryMenu();
  QPopupMenu* getProjectMenu();

  void runWcAutoUpdate();

public slots:
  void onItem( QListViewItem* item );
  void expanded( QListViewItem* item );
  void collapsed( QListViewItem* item );
  void mouseButtonPressed( int button, QListViewItem* item, const QPoint& pos, int c );
  void contextMenuRequest( QListViewItem* item, const QPoint& pos, int col );
  void itemRenamed( QListViewItem* item, int col, const QString& text );
  void keyPressEvent( QKeyEvent* e );
  void keyReleaseEvent( QKeyEvent* e );
  void focusOutEvent( QFocusEvent* e );
  void dragMoveEvent( QDragMoveEvent* e );
  void dropEvent( QDropEvent* e );

  void checkout();
  void switchx();
  void update();
  void updateRev();
  void commit();
  void diff();
  void log();
  void logWc();
  void branch();
  void tag();
  void setCurrentWc();

  void addPrj();
  void removePrj();
  void renamePrj();
  void prjSettings();
  void addPrjRepository();
  void addPrjWorkingCopy();
  void editWcPrjItem();
  void delWcPrjItem();
  void editRpPrjItem();
  void delRpPrjItem();
  void editTrunkBookmark();
  void editBranchesBookmark();
  void editTagsBookmark();
  void prjChanged( Project* prj );

  void closeRevPopup();
  
signals:
  void wcItemSelected();
  void wcStatusChanged();
  void wcStatusReset();

  void rpItemSelected();
  void rpEntryChanged();
  void rpEntryReset();

  void prjItemSelected();

  void prjSettings( Project* prj );


public:
  void list( long rpId, const sc::String& rpRoot, svn::RevisionPtr rev, Project*prj );
  void status( long wcId, const sc::String& wcRoot, Project* prj );
  void reload();

  void setRepository( long lviId, const svn::DirEntries& entries );
  void setWorkingCopy( long lviId, const svn::WcStatuss& statuss );

private:
  QString getWcSvnVersion();

private:
  RepositoryModel* _rpModel;
  WcModel*         _wcModel;
  bool             _ctrlKey; ///< is the control key pressed?

  QListViewItem*   _prevSelItem;

  QPopupMenu*      _revPopup;
  RevisionWidget*  _rev;

  // by making LviSelectedVisitor part of the ProjectFoldersWidget
  // class we can call the ProjectFoldersWidget protected signals.
  class LviSelectedVisitor;
};

#endif // _SC_PROJECTFOLDERSWIDGET_H
