/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTITEMPROPERTIES_H
#define _SC_PROJECTITEMPROPERTIES_H

// sc
#include "Project.h"
class ExternProvider;
class ExternButton;

// qt
#include <qdialog.h>
class QLineEdit;
class QPushButton;
class QCheckBox;


class ProjectItemProperties : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  ProjectItemProperties( const Project::Item& item, ExternProvider* p, QWidget* parent = 0 );
  virtual ~ProjectItemProperties();

  void accept();

  const Project::Item& getItem() const;

public slots:
  void autoUpdate( bool on );
  void checkOk( const QString& text );

private slots:
  void selectExtern();

private:

private:
  QLineEdit*      _name;
  QLineEdit*      _source;
  ExternButton*   _ex;

  QCheckBox*      _update;

  QPushButton*    _ok;
  QPushButton*    _ca;

  ExternProvider* _p;

  Project::Item   _item;
};

#endif // _SC_PROJECTITEMPROPERTIES_H
