/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CleanupCmd.h"
#include "CleanupParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"


CleanupCmd::CleanupCmd( CleanupParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

CleanupCmd::~CleanupCmd()
{
  delete _cb;
}

void CleanupCmd::run()
{
  sc::Error* err;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->cleanup( _param->getPath() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
