#include "utility.h"
#include "RegEx.h"

/*
 *
 */
RegEx::RegEx(const Glib::ustring &ex, int flags)
:m_pcre(NULL)
{
	se_debug_message(SE_DEBUG_REGEX, "expression=%s", ex.c_str());

	const char *error_ptr = NULL;
	int error_offset = 0;
	int error_code = 0;

	int options = PCRE_UTF8 | PCRE_MULTILINE;

	if(flags & CASELESS)
		options |= PCRE_CASELESS;

	m_pcre = pcre_compile2(ex.c_str(), options, 
			&error_code, &error_ptr, &error_offset, NULL);

	if(m_pcre == NULL || error_code != 0)
	{
		std::cerr << "Error: " << error_ptr << std::endl; 
		//return msg error_code
	}
}

/*
 *
 */
RegEx::~RegEx()
{
	se_debug(SE_DEBUG_REGEX);

	pcre_free(m_pcre);
}

/*
 *
 */
bool RegEx::exec(const Glib::ustring &string)
{
	se_debug_message(SE_DEBUG_REGEX, "string=%s", string.c_str());

	if(m_pcre == NULL)
		return false;

	int options = PCRE_ANCHORED;

	int rc = pcre_exec(
			(const pcre *)m_pcre,
			NULL,	
			string.c_str(), (int)string.bytes(),
			0, 
			options, 
			NULL, 0);

	if(rc >= 0)
		return true;

	return false;
}

/*
 *
 */
bool RegEx::exec(const Glib::ustring &string, Glib::ustring::size_type &start, Glib::ustring::size_type &len)
{
	se_debug_message(SE_DEBUG_REGEX, "string=%s", string.c_str());

	if(m_pcre == NULL)
		return false;

	int options = 0;

	int ovector[2];

	int rc = pcre_exec(
			(const pcre *)m_pcre,
			NULL,
			string.c_str(), (int)string.bytes(),
			0,
			options, 
			ovector, 2);

	if(rc >= 0)
	{
		std::string tmp = string;

		start = Glib::ustring( tmp.substr(0, ovector[0]) ).size();
		len = Glib::ustring( tmp.substr(ovector[0], ovector[1] - ovector[0]) ).size();

		return true;
	}
	return false;
}

