#ifndef _SubtitleSubRip_h
#define _SubtitleSubRip_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "Document.h"
#include "SubtitleFormat.h"

class SubtitleSubRip : public SubtitleFormat
{
public:
	SubtitleSubRip(Document* doc);
	~SubtitleSubRip();

	/*
	 *
	 */
	bool open(const Glib::ustring &filename, const Glib::ustring &encoding);

	/*
	 *
	 */
	bool save(const Glib::ustring &filename, const Glib::ustring &encoding);

	/*
	 *
	 */
	static Glib::ustring get_name();
	
	/*
	 *
	 */
	static bool check(const std::string &line);

	/*
	 *
	 */
	static Glib::ustring get_extension();

protected:

	/*
	 *	convertir le temps interne (SubtitleTime) 
	 *	en format SubRip
	 */
	Glib::ustring subtitletime_to_subrip_time(const Glib::ustring &time);

};

#endif//_SubtitleSubRip_h
