/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowContainerLayout;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.LineBox;

public class InlineFlowLayout
extends FlowContainerLayout {
    public InlineFlowLayout(FlowFigure flow) {
        super(flow);
    }

    public void addToCurrentLine(FlowBox block) {
        this.getCurrentLine().add(block);
        ((InlineFlow)this.getFlowFigure()).getFragments().add(this.currentLine);
    }

    protected void createNewLine() {
        this.currentLine = new LineBox();
        this.setupLine(this.currentLine);
    }

    protected void cleanup() {
        this.currentLine = null;
    }

    protected void flush() {
        if (this.currentLine != null) {
            this.context.addToCurrentLine(this.currentLine);
        }
    }

    public void endLine() {
        if (this.currentLine == null) {
            return;
        }
        if (this.currentLine.isOccupied()) {
            this.context.addToCurrentLine(this.currentLine);
        }
        this.context.endLine();
        this.currentLine = null;
    }

    public int getCurrentY() {
        return this.getCurrentLine().y;
    }

    public boolean isCurrentLineOccupied() {
        return !this.currentLine.getFragments().isEmpty() || this.context.isCurrentLineOccupied();
    }

    public void preLayout() {
        ((InlineFlow)this.getFlowFigure()).getFragments().clear();
    }

    protected void setupLine(LineBox line) {
        LineBox parent = this.context.getCurrentLine();
        line.x = 0;
        line.y = this.context.getCurrentY();
        line.setRecommendedWidth(parent.getAvailableWidth());
    }
}

