/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.io.IOException;
import java.net.URL;
import swingwt.awt.BorderLayout;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.FlowLayout;
import swingwt.awt.LayoutManager;
import swingwt.awt.Toolkit;
import swingwt.awt.event.ActionEvent;
import swingwt.awt.event.ActionListener;
import swingwt.awt.event.KeyEvent;
import swingwt.awt.event.KeyListener;
import swingwtx.swing.Icon;
import swingwtx.swing.ImageIcon;
import swingwtx.swing.JButton;
import swingwtx.swing.JEditorPane;
import swingwtx.swing.JFrame;
import swingwtx.swing.JOptionPane;
import swingwtx.swing.JPanel;
import swingwtx.swing.JScrollPane;
import swingwtx.swing.JTextField;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.event.HyperlinkEvent;
import swingwtx.swing.event.HyperlinkListener;

public class SwingWTBrowser
extends JFrame
implements HyperlinkListener,
ActionListener {
    private JButton homeButton;
    private JTextField urlField;
    private JEditorPane htmlPane;
    private String initialURL;

    public static void main(String[] stringArray) {
        if (SwingWTUtils.isMacOSX()) {
            SwingWTUtils.initialiseMacOSX((Runnable)new Runnable(){

                public void run() {
                    new SwingWTBrowser();
                }
            });
        } else if (stringArray.length == 0) {
            new SwingWTBrowser();
        } else {
            new SwingWTBrowser(stringArray[0]);
        }
    }

    public SwingWTBrowser() {
        this("");
    }

    public SwingWTBrowser(String string) {
        super("Simple SwingWT Browser");
        Dimension dimension;
        this.initialURL = string;
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FlowLayout());
        jPanel.add((Component)jPanel2, (Object)"West");
        this.homeButton = new JButton();
        this.homeButton.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/demo/Homepage.png")));
        this.homeButton.addActionListener((ActionListener)this);
        this.urlField = new JTextField(100);
        this.urlField.setText(string);
        jPanel.add((Component)this.urlField, (Object)"Center");
        this.urlField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    String string = SwingWTBrowser.this.urlField.getText();
                    try {
                        SwingWTBrowser.this.htmlPane.setPage(new URL(string));
                        SwingWTBrowser.this.urlField.setText(string);
                    }
                    catch (IOException iOException) {
                        SwingWTBrowser.this.warnUser("Can't follow link to " + string + ": " + iOException);
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        jPanel2.add((Component)this.homeButton);
        this.getContentPane().add((Component)jPanel, (Object)"North");
        String string2 = "<html><body><h2>Test HTML</h2><p>This is a simple browser test. Type in a URL at the top to go to a new location, or hit the home button to go back to the URL you supplied.</p></body></html>";
        try {
            this.htmlPane = string.equals("") ? new JEditorPane("text/html", string2) : new JEditorPane(string);
            this.htmlPane.setEditable(false);
            this.htmlPane.addHyperlinkListener((HyperlinkListener)this);
            dimension = new JScrollPane((Component)this.htmlPane);
            this.getContentPane().add((Component)dimension, (Object)"Center");
        }
        catch (IOException iOException) {
            this.warnUser("Can't build HTML pane for " + string + ": " + iOException);
        }
        dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width * 8 / 10;
        int n2 = dimension.height * 8 / 10;
        this.setBounds(n / 8, n2 / 8, n, n2);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.initialURL;
        if (string.equals("")) {
            this.warnUser("You didn't supply an initial home URL!");
            return;
        }
        try {
            this.htmlPane.setPage(new URL(string));
            this.urlField.setText(string);
        }
        catch (IOException iOException) {
            this.warnUser("Can't follow link to " + string + ": " + iOException);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlPane.setPage(hyperlinkEvent.getURL());
                this.urlField.setText(hyperlinkEvent.getURL().toExternalForm());
            }
            catch (IOException iOException) {
                this.warnUser("Can't follow link to " + hyperlinkEvent.getURL().toExternalForm() + ": " + iOException);
            }
        }
    }

    private void warnUser(String string) {
        JOptionPane.showMessageDialog((Container)this, (Object)string, (String)"Error", (int)1);
    }
}

