//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "RangeMaintFrm.h"
#include <versekey.h>
#include <listkey.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TRangeMaintForm *RangeMaintForm;

//---------------------------------------------------------------------------
__fastcall TRangeMaintForm::TRangeMaintForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::FormShow(TObject *Sender)
{
	ConfigEntMap::iterator loop, end;
	config = new SWConfig("./options.conf");	
	ListBox1->Clear();
	loop = config->Sections["CustomRanges"].begin();
	end = config->Sections["CustomRanges"].end();
	while (loop != end) {
		TCustomRange *rs = new TCustomRange(loop->first.c_str(), loop->second.c_str());
		ListBox1->Items->AddObject(rs->name.c_str(), rs);
		loop++;
	}
	ListBox1->ItemIndex = 0;
	if (ListBox1->ItemIndex) {
		SpeedButton1Click(0);
	}
	else {
		ListBox1Click(0);
		Button1Click(0);
	}
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::FormClose(TObject *Sender,
	 TCloseAction &Action)
{
	delete config;	
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::SpeedButton4Click(TObject *Sender)
{
	ModalResult = mrCancel;	
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::ListBox1Click(TObject *Sender)
{
	if (ListBox1->ItemIndex >= 0) {
		TCustomRange *rs = (TCustomRange *)ListBox1->Items->Objects[ListBox1->ItemIndex];

		NameEdit->Text = rs->name.c_str();
		TextEdit->Text = rs->text.c_str();
	}
	else {
		NameEdit->Text = "";
		TextEdit->Text = "";
	}
	Button1Click(0);
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::NameEditChange(TObject *Sender)
{
	if (ListBox1->ItemIndex < 0)
		return;
	TCustomRange *rs = (TCustomRange *)ListBox1->Items->Objects[ListBox1->ItemIndex];
	rs->name = NameEdit->Text.c_str();
	ListBox1->Items->Strings[ListBox1->ItemIndex] = rs->name.c_str();
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::TextEditChange(TObject *Sender)
{
	if (ListBox1->ItemIndex < 0)
		return;
	TCustomRange *rs = (TCustomRange *)ListBox1->Items->Objects[ListBox1->ItemIndex];
	rs->text = TextEdit->Text.c_str();
	Button1Click(0);
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::SpeedButton2Click(TObject *Sender)
{
	if (ListBox1->ItemIndex < 0)
		return;
	int delItem = ListBox1->ItemIndex;
	ListBox1->Items->Delete(delItem);
	ListBox1->ItemIndex = (delItem < ListBox1->Items->Count) ? delItem : delItem - 1;
	ListBox1Click(0);
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::SpeedButton1Click(TObject *Sender)
{
	TCustomRange *rs = new TCustomRange("[New Custom Range]", "");
	ListBox1->ItemIndex = ListBox1->Items->AddObject(rs->name.c_str(), rs);
	
	ListBox1Click(0);
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::SpeedButton3Click(TObject *Sender)
{
	TCustomRange *rs;
	config->Sections["CustomRanges"].erase(config->Sections["CustomRanges"].begin(), config->Sections["CustomRanges"].end());
	for (int i = 0; i < ListBox1->Items->Count; i++) {
		rs = (TCustomRange *)ListBox1->Items->Objects[i];
		config->Sections["CustomRanges"].insert(ConfigEntMap::value_type(rs->name.c_str(), rs->text.c_str()));
	}
	config->Save();
	ModalResult = mrOk;
}
//---------------------------------------------------------------------------
void __fastcall TRangeMaintForm::Button1Click(TObject *Sender)
{
	VerseKey key;
	ListBox2->Clear();
	ListKey verses = key.ParseVerseList(TextEdit->Text.c_str(), key, true);
	for (int i = 0; i < verses.Count(); i++) {
		VerseKey *element = SWDYNAMIC_CAST(VerseKey, verses.GetElement(i));
		if (element) {
			ListBox2->Items->Add((string(element->LowerBound()) + " - " + string(element->UpperBound())).c_str());
		}
		else	ListBox2->Items->Add((const char *)*verses.GetElement(i));
	}
}
//---------------------------------------------------------------------------
