unit SWKey;

interface

uses
	SwordAPI, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
	TSWKey = class(TComponent)
	private
	protected
		hswkey: integer;
          KeyType: AnsiString;
		procedure Loaded; override;
		function  GetText: AnsiString; virtual;
          procedure SetText(itext: AnsiString); virtual;
		function  GetPersist: Boolean; virtual;
          procedure SetPersist(ival: Boolean); virtual;
		function  GetSWHandle: integer; virtual;
		procedure SetSWHandle(ihandle: integer); virtual;

	public
		constructor Create(AOwner:TComponent); override;
          destructor  Destroy; override;
		procedure Initialize; virtual;
          property Text: AnsiString read GetText write SetText;
          property Persist: Boolean read GetPersist write SetPersist;
		function Error: integer; virtual;
          property SWHandle: integer read GetSWHandle write SetSWHandle;
		procedure Inc;	virtual;
          procedure Dec; virtual;
	published
	end;

procedure Register;

implementation

constructor TSWKey.Create(AOwner:TComponent);
begin
	inherited Create(AOwner);
     KeyType := 'StrKey';
     hswkey := 0;
end;


destructor TSWKey.Destroy;
begin
	if not (csDesigning in ComponentState) then
     begin
		if (hswkey <> 0) then
	     begin
	     	DeleteKey(hswkey);
	          hswkey := 0;
	     end;
     end;
	inherited Destroy;
end;


procedure TSWKey.Loaded;
begin
	inherited Loaded;
	if not (csDesigning in ComponentState) then
     begin
     	if (hswkey = 0) then
	     	Initialize;
     end;
end;


procedure TSWKey.Initialize;
begin
	if (hswkey <> 0) then
     	DeleteKey(hswkey);
	hswkey := NewKey(PChar(KeyType));
     Persist := true;
end;


function TSWKey.Error: integer;
begin
	Error := KeyError(hswkey);
end;


function TSWKey.GetText: AnsiString;
var
	s1: AnsiString;
begin
	SetLength(s1, 1024);
     KeyGetText(hswkey, PChar(s1), Length(s1));
     s1 := Trim(s1);
     GetText := s1;
end;


procedure TSWKey.SetText(itext: AnsiString);
begin
	KeySetText(hswkey, PChar(itext));
end;


function TSWKey.GetSWHandle: integer;
begin
	GetSWHandle := hswkey;
end;


procedure TSWKey.SetSWHandle(ihandle: integer);
begin
	hswkey := ihandle;
end;


function TSWKey.GetPersist: Boolean;
begin
	GetPersist := Boolean(KeyGetPersist(hswkey));
end;


procedure TSWKey.SetPersist(ival: Boolean);
begin
	KeySetPersist(hswkey, integer(ival));
end;


procedure TSWKey.Inc;
begin
	KeyInc(hswkey);
end;


procedure TSWKey.Dec;
begin
	KeyDec(hswkey);
end;







procedure Register;
begin
	RegisterComponents('Data Access', [TSWKey]);
end;

end.
