/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/if.h>
#include <net/route.h>
#include <arpa/inet.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>

#include "interface.h"
#include "errno.h"

using namespace std;

int sockets_open(void)
{
  static const int families[] = {
    AF_INET, AF_IPX, AF_AX25, AF_APPLETALK
  };
  unsigned int	i;
  int		sock;

  /* Try all families we support */
  for(i = 0; i < sizeof(families)/sizeof(int); ++i)
    {
      /* Try to open the socket, if success returns it */
      sock = socket(families[i], SOCK_DGRAM, 0);
      if(sock >= 0)
	return sock;
  }

  return -1;
}
 
 /* Fetch the interface configuration from the kernel. */
int if_fetch(struct interface *ife)
{
    struct ifreq ifr;
    char *ifname = ife->name; 
    int fd = sockets_open();
    
    if (fd >= 0) {
	strcpy(ifr.ifr_name, ifname);
	ifr.ifr_addr.sa_family = AF_INET;
	if (ioctl(fd, SIOCGIFADDR, &ifr) == 0) {
	    ife->has_ip = 1;
	    ife->addr = ifr.ifr_addr;
	    strcpy(ifr.ifr_name, ifname);
	    if (ioctl(fd, SIOCGIFDSTADDR, &ifr) < 0)
	        memset(&ife->dstaddr, 0, sizeof(struct sockaddr));
	    else
	        ife->dstaddr = ifr.ifr_dstaddr;

	    strcpy(ifr.ifr_name, ifname);
	    if (ioctl(fd, SIOCGIFBRDADDR, &ifr) < 0)
	        memset(&ife->broadaddr, 0, sizeof(struct sockaddr));
	    else
		ife->broadaddr = ifr.ifr_broadaddr;

	    strcpy(ifr.ifr_name, ifname);
	    if (ioctl(fd, SIOCGIFNETMASK, &ifr) < 0)
		memset(&ife->netmask, 0, sizeof(struct sockaddr));
	    else
		ife->netmask = ifr.ifr_netmask;
	} else
	    memset(&ife->addr, 0, sizeof(struct sockaddr));
    }
    close(fd);
    return 0;
}


int set_default_gw( int sockfd, char * ipgw ) 
{
	struct sockaddr_in *dst, *gw, *mask;
	struct rtentry route;

	memset(&route,0,sizeof(struct rtentry)); //reset the structure
	//pointers to distinct important parts in the routes structure
	dst = (struct sockaddr_in *)&(route.rt_dst);
	gw = (struct sockaddr_in *)&(route.rt_gateway);
	mask = (struct sockaddr_in *)&(route.rt_genmask);
	
	dst->sin_family = AF_INET;
	gw->sin_family = AF_INET;
	mask->sin_family = AF_INET;
	
	dst->sin_addr.s_addr = 0;
	gw->sin_addr.s_addr = 0;
	mask->sin_addr.s_addr = 0;
	route.rt_flags = RTF_UP | RTF_GATEWAY;
	
	//Remove the default route!!    
	ioctl(sockfd,SIOCDELRT,&route);
	
	//Set the data for the new default route
	dst->sin_addr.s_addr = 0;
	gw->sin_addr.s_addr = inet_addr(ipgw);
	mask->sin_addr.s_addr = 0;
	route.rt_flags = RTF_UP | RTF_GATEWAY;
	    
	//Remove this route if it already exists
	ioctl(sockfd,SIOCDELRT,&route);
	
	//Now I can add it :)
	if( ioctl(sockfd,SIOCADDRT,&route) == -1 ) {
		perror ("Adding default route");
		return -1;
	}

	return 0;
}
