/* rpackage.h - wrapper for accessing package information
 * 
 * Copyright (c) 2000, 2001 Conectiva S/A 
 * 
 * Author: Alfredo K. Kojima <kojima@conectiva.com.br>
 * 
 * Portions Taken from Gnome APT
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 * 
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */



#ifndef _RPACKAGE_H_
#define _RPACKAGE_H_

#include <vector>

#include <apt-pkg/pkgcache.h>

class pkgDepCache;
class RPackageLister;
class pkgRecords;

class RPackage {
   RPackageLister *_lister;
   
   pkgRecords *_records;
   pkgDepCache *_depcache;
   pkgCache::PkgIterator *_package;

   vector<pkgCache::PkgIterator> _virtualPackages; // virtual pkgs provided by this one
   
   // stuff for enumerators
   int _vpackI;
   pkgCache::DepIterator _rdepI;
   
   pkgCache::DepIterator _wdepI;
   pkgCache::DepIterator _wdepStart;
   pkgCache::DepIterator _wdepEnd;
   
   pkgCache::DepIterator _depI;
   pkgCache::DepIterator _depStart;
   pkgCache::DepIterator _depEnd;

   bool isShallowDependency(RPackage *pkg);

   bool isWeakDep(pkgCache::DepIterator &dep);
   
public:
   enum PackageStatus {
       SInstalledUpdated,
       SInstalledOutdated,
       SInstalledBroken, // installed but broken	   
       SNotInstalled
   };
   
   enum MarkedStatus {
       MKeep,
       MInstall,
       MUpgrade,
       MDowngrade,
       MRemove,
       MHeld
   };
   
   enum UpdateImportance {
       IUnknown,
       INormal,
       ICritical,
       ISecurity
   };
   
   pkgCache::PkgIterator *package() { return _package; };
   

   inline const char *name() { return _package->Name(); };
   
   const char *section();
   const char *priority();

   const string summary();
   const char *description();

   bool isImportant();

   bool downloadable();
   
   const string maintainer();
   const char *vendor();
   
   
   const char *installedVersion();
   long installedSize();

   // if this is an update
   UpdateImportance updateImportance();
   const char *updateSummary();
   const char *updateDate();
   const char *updateURL();

   // relative to version that would be installed
   const char *availableVersion();
   long availableSize();

   long packageSize();

   // installed package if installed, scheduled/candidate if not or if marked
   bool enumDeps(const char *&type, const char *&what, const char *&pkg,
		 const char *&which, char *&summary, bool &satisfied);
   bool nextDeps(const char *&type, const char *&what, const char *&pkg,
		 const char *&which, char *&summary, bool &satisfied);

   // reverse dependencies
   bool enumRDeps(const char *&dep, const char *&what);
   bool nextRDeps(const char *&dep, const char *&what);
   
   // weak dependencies
   bool enumWDeps(const char *&type, const char *&what, bool &satisfied);
   bool nextWDeps(const char *&type, const char *&what, bool &satisfied);

   // current status query
   PackageStatus getStatus();

   // selected status query
   MarkedStatus getMarkedStatus();

   bool wouldBreak();

   // change status
   
   void setKeep();
   void setInstall();
   void setRemove(bool purge = true); //XXX: purge for debian

   void setHeld(bool flag);

   // shallow doesnt remove things other pkgs depend on
   void setRemoveWithDeps(bool shallow, bool purge=true);
   
   void addVirtualPackage(pkgCache::PkgIterator dep);

   RPackage(RPackageLister *lister, pkgDepCache *depcache, pkgRecords *records,
	    pkgCache::PkgIterator &pkg);
   ~RPackage();
};

#endif
