
#include "config.h"

#include "i18n.h"

#include "rwwindow.h"



void RWWindow::windowCloseAction(WMWidget *win, void *data)
{
    RWWindow *rwin = (RWWindow*)data;
    
    rwin->close();
}


RWWindow::RWWindow(WMScreen *scr, string name, bool makeBox)
{
    _win = WMCreateWindow(scr, (char*)name.c_str());

    WMSetWindowCloseAction(_win, windowCloseAction, this);
    
    if (makeBox) {
	_topBox = WMCreateBox(_win);
	WMMapWidget(_topBox);
	WMSetBoxBorderWidth(_topBox, 5);
	WMSetViewExpandsToParent(WMWidgetView(_topBox), 0, 0, 0, 0);
    } else {
	_topBox = NULL;
    }
}


RWWindow::RWWindow(RWWindow *parent, string name, bool makeBox, bool closable)
{
    int style = WMTitledWindowMask | WMResizableWindowMask;

    if (closable)
	style |= WMClosableWindowMask;

    _win = WMCreatePanelWithStyleForWindow(parent->window(),
					   (char*)name.c_str(),
					   style);
    
    WMSetWindowCloseAction(_win, windowCloseAction, this);
    
    if (makeBox) {
	_topBox = WMCreateBox(_win);
	WMMapWidget(_topBox);
	WMSetBoxBorderWidth(_topBox, 5);
	WMSetViewExpandsToParent(WMWidgetView(_topBox), 0, 0, 0, 0);
    } else {
	_topBox = NULL;
    }
}


RWWindow::~RWWindow()
{
//    cout << "Desotry wind"<<endl;
    WMDestroyWidget(_win);
}


void RWWindow::setTitle(string title)
{
    WMSetWindowTitle(_win, (char*)title.c_str());
}

void RWWindow::close()
{
    hide();
}
