/* ========================================================================== */
/* === umfpack_report_perm ================================================== */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

int umfpack_report_perm
(
    const char name [ ],
    int n,
    const int P [ ],
    const double Control [UMFPACK_CONTROL]
) ;

long umfpack_l_report_perm
(
    const char name [ ],
    long n,
    const long P [ ],
    const double Control [UMFPACK_CONTROL]
) ;

/*
int Syntax:

    #include "umfpack.h"
    int n, *P, status ;
    double Control [UMFPACK_CONTROL] ;
    status = umfpack_report_perm ("P", n, P, Control) ;

long Syntax:

    #include "umfpack.h"
    long n, *P, status ;
    double Control [UMFPACK_CONTROL] ;
    status = umfpack_l_report_perm ("P", n, P, Control) ;

Purpose:

    Verifies and prints a permutation vector.

Returns:

    UMFPACK_OK if Control [UMFPACK_PRL] <= 2 (the input is not checked).

    Otherwise:

    UMFPACK_OK if the permutation vector is valid (this includes that case
	when P is (Int *) NULL, which is not an error condition.

    UMFPACK_ERROR_n_nonpositive if n <= 0.
    UMFPACK_ERROR_out_of_memory if out of memory.
    UMFPACK_ERROR_invalid_permutation if P is not a valid permutation vector.

Arguments:

    char name [ ] ;	Input argument, not modified.

	The name of the permutation vector.  This is optional; no name is
	printed if a (char *) NULL pointer is passed.

    Int n ;		Input argument, not modified.

	P is an integer vector of size n.  Restriction: n > 0.

    Int P [n] ;		Input argument, not modified.

	A permutation vector of size n.  If P is not present (a (Int *) NULL
	pointer, then P is assumed to be the identity permutation.  This is
	consistent with its use as an input argument to umfpack_qsymbolic.
	If P is present, the entries in P must range between 0 and n-1, and no
	duplicates may exists.

    double Control [UMFPACK_CONTROL] ;	Input argument, not modified.

	If a (double *) NULL pointer is passed, then the default control
	settings are used.  Otherwise, the settings are determined from the
	Control array.  See umfpack_defaults on how to fill the Control
	array with the default settings.  The following Control parameters
	are used:

	Control [UMFPACK_PRL]:  printing level.

	    2 or less: no output.  returns silently without checking anything.
	    3: fully check input, and print a short summary of its status
	    4: as 3, but print first few entries of the input
	    5: as 3, but print all of the input
	    Default: 1

*/

