/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef VISU_WINDOWINTERFACE_H
#define VISU_WINDOWINTERFACE_H

#include <glib.h>
#include <visu_data.h>

#include "visu_windowInterface_def.h"
#include "visu_actionInterface.h"
#include <visu_dump.h>
#include "openGLFunctions/interactive.h"

/*************************************/
/* Dealing with the rendering window */
/*************************************/

/**
 * visuRenderingWindowInit:
 * @windowRef: a title for the window ;
 * @iconRef: a path to an icon (may be NULL) ;
 * @window_name: a string to identify the window inside a class of
 * window ;
 * @class_name: a string to identify the class of the window ;
 * @width: the width ;
 * @height: the height.
 *
 * This routine will call the backend windowing method to create a
 * rendering window.
 *
 * Returns: 0 if everything went right.
 */
int visuRenderingWindowInit(char* windowRef, char* iconRef, char* window_name,
			    char* class_name, int width, int height);

/**
 * setObserveEventListener:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering).
 *
 * Bring up the interactive mode listeners (clic, drag...) for observe mode
 * and connect then to the given methods pointed by @userCallbacks.
 */
void setObserveEventListener(GenericRenderingWindow window);
/**
 * setPickEventListener:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering).
 *
 * Bring up the interactive mode listeners (clic, drag...) for pick mode
 * and connect then to the given methods pointed by @userCallbacks.
 */
void setPickEventListener(GenericRenderingWindow window);
/**
 * removeEventListener:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering).
 *
 * Remove all listeners responsible for the interactive mode.
 */
void removeEventListener(GenericRenderingWindow window);
/**
 * setInteractiveHandlers:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering) ;
 * @inter: an interactive descriptive session.
 *
 * Set the listeners needed for the @inter argument.
 */
void setInteractiveHandlers(GenericRenderingWindow window, VisuInteractive *inter);

/**
 * visuRenderingWindowSet_visuData:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering) ;
 * @data: a #VisuData to render in the given @window.
 *
 * This method is used to attach a #VisuData object to a given window.
 * When, @data is not NULL, this method emit the dataReadyForRendering signal,
 * and all modules that needs to draw something should catch this signal and
 * draw in the rendering window. If @data is NULL, the dataNotReadyForRendering
 * is emitted instead.
 */
void visuRenderingWindowSet_visuData(GenericRenderingWindow window, VisuData *data);
/**
 * visuRenderingWindowGet_visuData:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering).
 *
 * This method is used to get the #VisuData attached to a window.
 *
 * Returns: the #VisuData attached to the @window or NULL if none.
 */
VisuData* visuRenderingWindowGet_visuData(GenericRenderingWindow window);

/**
 * visuRenderingWindowDump:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering) ;
 * @format: a #DumpType object, corresponding to the write method ;
 * @fileName: a string that defined the file to write to ;
 * @width: an integer ;
 * @height: an integer ;
 * @error: a location to store some error (not NULL) ;
 * @functionWait: a method to call periodically during the dump ;
 * @data: some pointer on object to be passed to the wait function.
 *
 * Call this method to dump the given @window to a file.
 *
 * Returns: TRUE if everything went right.
 */
gboolean visuRenderingWindowDump(GenericRenderingWindow window, DumpType *format,
				 char* fileName, gint width, gint height, GError **error,
				 voidDataFunc functionWait, gpointer data);

/**
 * checkWindowSize:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering) ;
 * @width: a pointer to store the width of the window ;
 * @height: a pointer to store the height of the window.
 *
 * Get the rendering window size by asking the X server.
 */
void checkWindowSize(GenericRenderingWindow window,
		     unsigned int *width, unsigned int *height);

/**
 * visuRenderingWindowGet_backgroundColor:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering) ;
 * @rgb: an allocated array of three floating point values.
 *
 * This method is used to retrieve the color of the rendering
 * window, depending on its style (see v_sim.rc for example if the rendering
 * window is monitored by GTK).
 */
void visuRenderingWindowGet_backgroundColor(GenericRenderingWindow window, float rgb[3]);

/**
 * visuRenderingWindowGet_backgroundImage:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering) ;
 * @rowData: a pointer to be set on the data in memory ;
 * @hasAlphaChannel: a pointer to store if the loaded iage has an alpha channel ;
 * @width: store the width ;
 * @height: store the height.
 *
 * Use this method to load an image in memory (according to GdkPixbuf
 * specification) and retrieve the row data in memory. 
 *
 * Returns: a pointer to an opaque structure that must be freed after use
 *          by a call to visuRenderigWindowFree_backgroundImage:().
 */
gpointer visuRenderingWindowGet_backgroundImage(GenericRenderingWindow window,
					       guchar **rowData, gboolean *hasAlphaChannel,
					       int *width, int *height);

/**
 * visuRenderingWindowFree_backgroundImage:
 * @window: a pointer on a valid rendering window object (see #RenderingWindow
 *          if GTK is used for rendering) ;
 * @image: an opaque structure returned by visuRenderigWindowGet_backgroundImage().
 *
 * Free loaded image.
 */
void visuRenderingWindowFree_backgroundImage(GenericRenderingWindow window, gpointer image);

/**
 * visuRenderingWindowGet_current:
 *
 * Method used to get a pointer to the current active window.
 *
 * Returns: a pointer to the current active window.
 */
GenericRenderingWindow visuRenderingWindowGet_current();
/**
 * visuRenderingWindowSet_default:
 * @window: a pointer to a rendering area to become default.
 *
 * Method used to set the window returned by visuRenderingWindowGet_current().
 */
void visuRenderingWindowSet_default(GenericRenderingWindow window);

#endif
