/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#ifndef GTK_TOOLPANELWIDGET_H
#define GTK_TOOLPANELWIDGET_H

#include <glib.h>
#include <gtk/gtk.h>

#include <visu_data.h>

G_BEGIN_DECLS
/**
 * TOOL_PANEL_TYPE:
 *
 * Return the associated #GType to the ToolPanel objects.
 */
#define TOOL_PANEL_TYPE         (toolPanel_get_type ())
/**
 * TOOL_PANEL:
 * @obj: the widget to cast.
 *
 * Cast the given object to a #ToolPanel object.
 */
#define TOOL_PANEL(obj)         (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOOL_PANEL_TYPE, ToolPanel))
/**
 * TOOL_PANEL_CLASS:
 * @klass: the class to cast.
 *
 * Cast the given class to a #ToolPanelClass object.
 */
#define TOOL_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TOOL_PANEL_TYPE, ToolPanelClass))
/**
 * IS_TOOL_PANEL:
 * @obj: the object to test.
 *
 * Return if the given object is a valid #ToolPanel object.
 */
#define IS_TOOL_PANEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOOL_PANEL_TYPE))
/**
 * IS_TOOL_PANEL_CLASS:
 * @klass: the class to test.
 *
 * Return if the given class is a valid #ToolPanelClass class.
 */
#define IS_TOOL_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOOL_PANEL_TYPE))

/**
 * ToolPanel
 *
 * Short form for a #ToolPanel_struct structure.
 */
typedef struct _ToolPanel ToolPanel;
/**
 * ToolPanelClass
 *
 * Short form for a #ToolPanelClass_struct structure.
 */
typedef struct _ToolPanelClass ToolPanelClass;

/**
 * toolPanel_get_type
 *
 * #GType are unique numbers to identify objects.
 *
 * Returns: the #GType associated with #ToolPanel objects.
 */
GType          toolPanel_get_type        (void);
/**
 * DockWindow:
 *
 * Short name for the structure of containers of #ToolPanel.
 */
typedef struct _DockWindow DockWindow;

/**
 * toolPanelNew:
 * @id: a string without space and non internationalised ;
 * @name: a string in UTF-8 that can be internationalised ;
 * @tabName: a shorter name than @name, in UTF-8 that can be
 * internationalised.
 *
 * Create a new #ToolPanel with the given @id, displaying @name in the
 * combo box of a #DockWindow and @tabName in the tab of the page
 * notebook.
 *
 * Returns: a newly created widget.
 */
GtkWidget* toolPanelNew(gchar *id, gchar* name, gchar *tabName);
/**
 * toolPanelNew_withIconFromPath:
 * @id: a string without space and non internationalised ;
 * @name: a string in UTF-8 that can be internationalised ;
 * @tabName: a shorter name than @name, in UTF-8 that can be
 * internationalised ;
 * @iconPath: a path to an icon (should be 20x20).
 *
 * Create a new #ToolPanel with the given @id, displaying @name in the
 * combo box of a #DockWindow and @tabName in the tab of the page
 * notebook. The displayed icon will be read from the @iconPath.
 *
 * Returns: a newly created widget.
 */
GtkWidget* toolPanelNew_withIconFromPath(gchar *id, gchar* name, gchar *tabName,
					 const gchar* iconPath);
/**
 * toolPanelNew_withIconFromStock:
 * @id: a string without space and non internationalised ;
 * @name: a string in UTF-8 that can be internationalised ;
 * @tabName: a shorter name than @name, in UTF-8 that can be
 * internationalised ;
 * @stock: the name of a stock icon.
 *
 * Create a new #ToolPanel with the given @id, displaying @name in the
 * combo box of a #DockWindow and @tabName in the tab of the page
 * notebook. The displayed icon will be taken from the @stock.
 *
 * Returns: a newly created widget.
 */
GtkWidget* toolPanelNew_withIconFromStock(gchar *id, gchar* name, gchar *tabName,
					  const gchar* stock);
/**
 * toolPanelGet_headerWidget:
 * @toolPanel: a #ToolPanel.
 *
 * The #ToolPanel should be used in a page of a #GtkNotebook. This
 * routine is used to get the widget that should be used in the
 * tab. This widget is a container with an icon and a label.
 *
 * Returns: a container widget that should be put in the tab of a
 * #GtkNotebook.
 */
GtkWidget* toolPanelGet_headerWidget(ToolPanel *toolPanel);
/**
 * toolPanelGet_label:
 * @toolPanel: a #ToolPanel.
 *
 * The #ToolPanel has two label, a short one, used in the tab of a
 * #GtkNotebook and one longer. This routine gets the longer.
 *
 * Returns: an UTF-8 internationalised name (property of V_Sim, should
 * not be freed).
 */
const gchar* toolPanelGet_label(ToolPanel *toolPanel);
/**
 * toolPanelGet_id:
 * @toolPanel: a #ToolPanel.
 *
 * The #ToolPanel can be identifyed by an id (a string without space,
 * usually using ASCII characters only).
 *
 * Returns: a constant string identifying this #ToolPanel.
 */
const gchar* toolPanelGet_id(ToolPanel *toolPanel);
/**
 * toolPanelSet_dockable:
 * @toolPanel: a #ToolPanel ;
 * @value: a boolean.
 *
 * A #ToolPanel can be moved between different #DockWindow or
 * not. This ability is controlled by the dockable flag. Change it
 * with this method. If @toolPanel is set dockable, then, it can be
 * hidden or moved to another or a new #DockWindow with the pop-up
 * memu that is triggered by a small button in the header widget (see
 * toolPanelGet_headerWidget()).
 */
void toolPanelSet_dockable(ToolPanel *toolPanel, gboolean value);
/**
 * toolPanelAttach:
 * @toolPanel: a #ToolPanel ;
 * @dock: a #DockWindow.
 *
 * Put the given @toolPanel in the given @dock window. It adds in this
 * dock window a new page in the #GtkNotebook using as tab header the
 * widget returned by toolPanelGet_headerWidget().
 */
void toolPanelAttach(ToolPanel *toolPanel, DockWindow *dock);
/**
 * toolPanelDetach:
 * @toolPanel: a #ToolPanel.
 *
 * Remove the given @toolPanel from its current container and add it
 * to the list of hidden tool panels. It can be added again using the
 * pop-up menu of any #DockWindow.
 */
void toolPanelDetach(ToolPanel *toolPanel);
/**
 * toolPanelGet_containerWindow:
 * @toolPanel: a #ToolPanel.
 *
 * Return the #GtkWindow that the given @toolPanel is rendered in or
 * NULL if the @toolPanel is currently dettached.
 *
 * Returns: a #GtkWindow object.
 */
GtkWindow* toolPanelGet_containerWindow(ToolPanel *toolPanel);
/**
 * toolPanelGet_container:
 * @toolPanel: a #ToolPanel.
 *
 * Return the #DockWindow that the given @toolPanel is attached to or
 * NULL if the @toolPanel is currently dettached.
 *
 * Returns: a #DockWindow object.
 */
DockWindow* toolPanelGet_container(ToolPanel *toolPanel);
/**
 * toolPanelGet_containerId:
 * @toolPanel: a #ToolPanel.
 *
 * Return the identifying string of the #DockWindow that the given
 * @toolPanel is attached to or NULL if the @toolPanel is currently dettached.
 *
 * Returns: a string owned by V_Sim.
 */
const gchar* toolPanelGet_containerId(ToolPanel *toolPanel);
/**
 * toolPanelSet_container:
 * @toolPanel: a #ToolPanel ;
 * @window: a #DockWindow.
 *
 * Change the container of a toolPanel. If it is currently attached to
 * a #DockWindow, it firstly detachs it.
 */
void toolPanelSet_container(ToolPanel *toolPanel, DockWindow *window);
/**
 * toolPanelSet_containerId:
 * @toolPanel: a #ToolPanel ;
 * @id: a #DockWindow identifier.
 *
 * Change the container of a toolPanel using the given @id. If it is
 * currently attached to a #DockWindow, it firstly detachs it.
 */
void toolPanelSet_containerId(ToolPanel *toolPanel, const gchar *id);
/**
 * toolPanelGet_visuData:
 * @toolPanel: a #ToolPanel.
 *
 * The @toolPanel is supposed to work on a #VisuData, this routine can
 * be used to get it.
 *
 * Returns: the currently focused #VisuData (can be NULL if none).
 */
VisuData* toolPanelGet_visuData(ToolPanel *toolPanel);
/**
 * toolPanelGet_visible:
 * @toolPanel: a #ToolPanel.
 *
 * This is used to retrieve if the @toolPanel is currently realised
 * and the visualised page of the #GtkNotebook it is associated to.
 *
 * Returns: TRUE if the given @toolPanel is potentialy visible to the user.
 */
gboolean toolPanelGet_visible(ToolPanel *toolPanel);

/* Associated variables and methods. */
/**
 * dockWindowGet_container:
 * @dock: a dock window descriptor.
 *
 * A dock window is a small utility window with a list of #ToolPanel.
 * This window can be embedded in a container or have its own
 * GtkWindow. This routine get the top-level container inside a given
 * #DockWindow. If you prefer to get the GtkWindow containing the
 * #DockWindow use dockWindowGet_window() instead.
 *
 * Returns: a top-level container (usually a #GtkVBox).
 */
GtkWidget* dockWindowGet_container(DockWindow *dock);
/**
 * dockWindowGet_notebook:
 * @dock: a dock window descriptor.
 *
 * A dock window is a small utility window with a list of #ToolPanel.
 * All #ToolPanel are contained in a #GtkNotebook. This routine gets it.
 *
 * Returns: the #GtkNotebook containing the #ToolPanel of this
 * #DockWindow.
 */
GtkWidget* dockWindowGet_notebook(DockWindow *dock);
/**
 * dockWindowGet_window:
 * @dock: a dock window descriptor.
 *
 * A dock window is a small utility window with a list of #ToolPanel.
 * This window can be embedded in a container or have its own
 * GtkWindow. This routine get the #GtkWindow containing the
 * #DockWindow in the case the dock is stand-alone. If not NULL is returned.
 *
 * Returns: a top-level container (usually a #GtkWindow) or NULL.
 */
GtkWidget* dockWindowGet_window(DockWindow *dock);

/* Class methods. */
/**
 * toolPanelClassSet_visuData:
 * @dataObj: a #VisuData object.
 *
 * Set the currently focussed #VisuData. It then can be retrieve using
 * toolPanelGet_visuData().
 */
void toolPanelClassSet_visuData(VisuData *dataObj);
/**
 * toolPanelClassSet_headerVisibility:
 * @status: a boolean.
 *
 * The header can be represented using the full image and label always
 * or only the image when the tab is not on top.
 */
void toolPanelClassSet_headerVisibility(gboolean status);
/**
 * toolPanelClassGet_commandPanel:
 *
 * There is always a #DockWindow that is inside the command
 * panel. This routine gets it.
 *
 * Returns: the #DockWindow that is inside the command panel.
 */
DockWindow* toolPanelClassGet_commandPanel(void);
/**
 * toolPanelClassGet_container:
 * @id: a #DockWindow identifier.
 *
 * This routine associates a #DockWindow identifier to the object pointer.
 *
 * Returns: the #DockWindow that corresponds to this identifier. The
 * dock window is built if not currently exist.
 */
DockWindow* toolPanelClassGet_container(const gchar *id);
/**
 * toolPanelClassGet_toolPanelById:
 * @id: a #ToolPanel identifier.
 *
 * This routine associates a #ToolPanel identifier to the object pointer.
 *
 * Returns: the #ToolPanel that corresponds to this identifier or NULL
 * if none exists.
 */
ToolPanel* toolPanelClassGet_toolPanelById(const gchar *id);
/**
 * toolPanelClassGet_allToolPanels:
 *
 * This routine can be used to know all existing #ToolPanel.
 *
 * Returns: a newly created list (use g_list_free() on it after use).
 */
GList* toolPanelClassGet_allToolPanels(void);
/**
 * toolPanelClassGet_allWindows:
 *
 * This routine can be used to know all existing #DockWindow.
 *
 * Returns: a newly created list (use g_list_free() on it after use).
 */
GList* toolPanelClassGet_allWindows(void);
/**
 * toolPanelClassGet_windowCharacteristics:
 * @dock: a #DockWindow object ;
 * @id: a location to store the identifier (owned by V_Sim) ;
 * @visibility: a location to store the status of the dock, hidden or
 * not ;
 * @x: a location to store its x position on the root window ;
 * @y: a location to store its y position on the root window ;
 * @width: a location to store its width ;
 * @height: a location to store its height.
 *
 * A routine to know everything about a #DockWindow.
 */
void toolPanelClassGet_windowCharacteristics(DockWindow *dock, gchar **id, 
					     gboolean *visibility, 
					     gint *x, gint *y, 
					     gint *width, gint *height);
/**
 * toolPanelClassSet_windowSize:
 * @id: a #DockWindow identifier ;
 * @width: the requested width ;
 * @height: the requested height.
 *
 * Change the size of the given #DockWindow. The size is possibly
 * adapted to avoid been out of screen.
 */
void toolPanelClassSet_windowSize(const gchar *id, guint width, guint height);
/**
 * toolPanelClassSet_windowPosition:
 * @id: a #DockWindow identifier ;
 * @x: the requested x position ;
 * @y: the requested y position.
 *
 * Change the position of the given #DockWindow. The position is possibly
 * adapted to avoid been out of screen.
 */
void toolPanelClassSet_windowPosition(const gchar *id, guint x, guint y);
/**
 * toolPanelClassSet_windowVisibility:
 * @id: a #DockWindow identifier ;
 * @visible: a boolean.
 *
 * Change the visibility of a #DockWindow. If hidden, the dock is
 * added to the list of hidden #DockWindow that can be shown again
 * using the pop-up menu on every visible #DockWindow. The 'Main' dock
 * window can not be hidden.
 */
void toolPanelClassSet_windowVisibility(const gchar *id, gboolean visible);

G_END_DECLS

#endif
