/***************************************************************************
                          dchublistmanager.h  -  description
                             -------------------
    begin                : Mon Oct 1 2001
    copyright            : (C) 2001-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCHUBLISTMANAGER_H
#define DCHUBLISTMANAGER_H

/**
  *@author Mathias Küster
  */

#include <qtimer.h>
#include <QFrame>
#include <QList>
#include <QMap>
#include <QMutex>

#include "DCDialogHubListManager.h"

#include <dclib/chublistmanager.h>

class QEvent;
class QCloseEvent;
class QResizeEvent;
class QShowEvent;
class QMdiSubWindow;
class PublicHubsModel;
class PublicHubsProxy;
class QTreeWidgetItem;
class DC_HubFilterObject;
class CDCMessage;

/* filtered hub list for search dialog not yet re-written */
#include <dclib/core/cstringlist.h>

class DCHubListManager : public QWidget, private Ui::DCDialogHubListManager, public CHubListManager {
Q_OBJECT

public:
	/** construtor */
	DCHubListManager( QWidget * parent = 0 );
	/** destructor */
	virtual ~DCHubListManager();

	/** Get the MDI subwindow we are in */
	QMdiSubWindow * GetMdiSubWindow() { return m_pContainerWindow; };
	/** */
	void InitDocument();
	/** */
	void DeInitDocument();
	/** */
	void ShowPublicHubList();
	/** */
	void ShowBookmarkList();
	/** */
	void AddBookmark( QString hubname, QString hubhost, QString description );
	/** */
	void RemoveBookmark( QTreeWidgetItem * item );
	/** */
	void UpdateBookmark( QString hubname, QString hubhost, QString description );
	/** */
	CStringList<CString> * GetFilteredHubList();

	/** callback function */
	virtual int DC_CallBack( CDCMessage * );

protected:
	/** Adjust column sizes preserving user set size ratios */
	void SizeColumnsPreservingRatios();

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );
	/** overridden so that the column widths are initialized on first show() */
	virtual void showEvent( QShowEvent * event );
	/** for removing mdi sub window from mdi area */
	virtual void closeEvent( QCloseEvent * event );

private:
	/** */
	void SetToolBar( QFrame * frame1, QFrame * frame2, bool vis );
	/**
	 * Update CConfig with the new sorted order of the bookmarks.
	 */
	void updateBookmarkOrder();
	/**
	 * Show the "Remove bookmarks" confirmation unless it's been disabled.
	 * 0 = remove, 1 = cancel
	 */
	int queryRemoveBookmarks();

	/** */
	QMutex m_HLMMutex;
	/** */
	QMap<QString, DC_HubFilterObject*> m_HubFilterMap;
	/** */
	QTimer m_Timer;
	/** */
	QList<CDCMessage*> * m_pMessageList;
	/** */
	QMdiSubWindow * m_pContainerWindow;
	/** */
	PublicHubsModel * model;
	/** */
	PublicHubsProxy * proxy;
	/** The last width that we adjusted the size of the public hubs columns for */
	int lastPublicHubsWidth;
	/** The last width that we adjusted the size of the bookmark hubs columns for */
	int lastBookmarkHubsWidth;

private slots:
	/** reload public hub list */
	void slotReloadPublicHubList();
	/** update public hub list */
	void slotUpdatePublicHubList();
	/** */
	void slotItemActivatedPublic( const QModelIndex & index );
	/** */
	void slotItemActivatedBookmarks( QTreeWidgetItem * item, int column );
	/** */
	void slotConnect();
	/** */
	void slotContextMenuPublicList( const QPoint & );
	/** */
	void slotContextMenuBookmarkList( const QPoint & );
	/** current tab widget change slot */
	void slotTabWidgetCurrentChange( QWidget * );
	/** */
	void slotAddFilter();
	/** */
	void slotEditFilter();
	/** */
	void slotDelFilter();
	/** */
	void slotFilterChange( const QString & );
	/** */
	void timerDone();
	/** */
	void slotMoveBookmarkUp();
	/** */
	void slotMoveBookmarkDown();
	/** */
	void slotEnableBookmarkSorting();
	/** */
	void slotSaveBookmarks();
	/** */
	void slotAltRowColors( bool enable );
	/** */
	void slotAddBookmark();
	/** */
	void slotEditBookmark();
	/** */
	void slotDelBookmark();
};

/** */
extern DCHubListManager * g_pHubListManager;

#endif
