/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0
 * December 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <vdk/application.h>
#include <vdk/forms.h>
#include <gdk/gdkkeysyms.h>
static int answer = 0;
static int mtype = 0;
static int timerId = 0;

static int
OnDialogDestroy (GtkWidget* dialog, gpointer gp)
{
  if(timerId)
    {
      gtk_timeout_remove(timerId);
      timerId = 0;
    }
  gtk_widget_destroy(dialog);  
  gtk_main_quit();
  return TRUE;
}

static void
OnDialogResponse(GtkWidget *dialog, gint response_id, gpointer gp)
{
  switch(response_id)
    {
      case GTK_RESPONSE_OK:
        answer = IDOK;
        break;
      case GTK_RESPONSE_CANCEL:
        answer = IDCANCEL;
        break;
      case GTK_RESPONSE_YES:
        answer = IDYES;
        break;
      case GTK_RESPONSE_NO:
        answer = IDNO;
        break;
      case  GTK_RESPONSE_DELETE_EVENT:
        switch(mtype & MB_TYPEMASK)
          {
            case MB_OKCANCEL:
              answer = IDCANCEL;
            break;
            case MB_YESNO:
              answer = IDNO;
            break;
            default:
            answer = IDCANCEL;
          }
      break;
      default:
      answer = response_id;
    }
  OnDialogDestroy(dialog,NULL);
}

static int
OnDialogKeyPress(GtkWidget *dialog, GdkEvent* ev, gpointer gp)
{
 GdkEventKey* event = (GdkEventKey*) ev;
 int answer = -1;
 switch(event->keyval)
   {
   case GDK_Return :
     switch(mtype & MB_TYPEMASK)
       {
      case MB_OKCANCEL:
        answer = IDOK;
        break;
      case MB_YESNO:
        answer = IDYES;
        break;
      default:
         answer = IDOK;
       }
     break;
   case GDK_Escape:
     switch(mtype & MB_TYPEMASK)
       {
      case MB_OKCANCEL:
        answer = IDCANCEL;
        break;
      case MB_YESNO:
        answer = IDNO;
        break;
      default:
         answer = IDCANCEL;
       }
   }
 if(answer >= 0)
   {
     OnDialogResponse(dialog, answer, gp);
     return TRUE;
   }
 else
   return FALSE;
}


static int HandleTimeOut(gpointer gp)
{

  if(timerId)
    {
      gtk_timeout_remove(timerId);
      timerId = 0;
    }
  GtkWidget* dialog = reinterpret_cast <GtkWidget*>(gp);
  OnDialogResponse(dialog, GTK_RESPONSE_DELETE_EVENT,NULL);
  return FALSE;
}



static GtkWidget* 
MakeDialog(GtkMessageType  type,GtkButtonsType  buttons, char* prompt,
  GtkWindow* parent, unsigned int wait)
{
  answer = 0;
  GtkWidget* dialog = 
  gtk_message_dialog_new (
          parent,
          GtkDialogFlags(GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT),
          type,
          buttons,
          prompt);

  if(parent)
    {
      gtk_window_set_transient_for (GTK_WINDOW (dialog),
                                  GTK_WINDOW (parent));
      gtk_window_set_destroy_with_parent (GTK_WINDOW (dialog), TRUE);
      gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
    }

  gtk_signal_connect (GTK_OBJECT (dialog), "destroy",
		      GTK_SIGNAL_FUNC (::OnDialogDestroy), NULL);

  gtk_signal_connect (GTK_OBJECT (dialog), "key_press_event",
		      GTK_SIGNAL_FUNC (::OnDialogKeyPress), NULL);

  gtk_signal_connect (GTK_OBJECT (dialog),
                      "response",
                      GTK_SIGNAL_FUNC (::OnDialogResponse),
                      NULL);
  if(wait)
    timerId = gtk_timeout_add(wait,::HandleTimeOut,dialog);
  return dialog;
}

gint 
VDKApplication::MessageBox(char* caption, char* text,
  int mode,char *oktext ,char *canceltext ,unsigned int wait)
{
  GtkMessageType type;
  GtkButtonsType buttons;
  mtype = mode;
  /* masks icon */

  switch(mode & MB_ICONMASK)
    {
      case MB_ICONQUESTION:
        type = GTK_MESSAGE_QUESTION;
        break;
      case MB_ICONINFORMATION:
        type = GTK_MESSAGE_INFO;
        break;
      case MB_ICONERROR:
        type = GTK_MESSAGE_ERROR;
        break;
      case MB_ICONSTOP:
        type = GTK_MESSAGE_WARNING;
        break;
      default:
        type = GTK_MESSAGE_INFO;
   }
  /* masks buttons */
   switch(mode & MB_TYPEMASK)
    {
      case MB_OKCANCEL:
        buttons = GTK_BUTTONS_OK_CANCEL;  
        break;
      case MB_YESNO:
        buttons = GTK_BUTTONS_YES_NO;  
        break;
      case MB_OK:
        buttons = GTK_BUTTONS_OK;
        break;
      default:
        buttons = GTK_BUTTONS_OK;
      break;
    } 
  GtkWidget *dialog = MakeDialog(type,
        buttons,
        text,
        GTK_WINDOW(MainForm->Window()),
        wait);
  if(caption)
    gtk_window_set_title(GTK_WINDOW(dialog),caption);
  gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_CENTER);
  gtk_widget_show(dialog);
  gtk_main();
  /*
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
  */
  return answer;
}
