/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <vdkb/vdkb_unit.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_utils.h>
static char buff[512];
////////////////////////// CLASS VDKBUNIT
/*
try to understand the unit type
based on file extension.
(i know isn't an elegant way,
but till now i can't do better)
*/
char *ext_types[] = { NULL,"o","a","prj","c","form",NULL};

VDKBUnit::VDKBUnit(char* name, int status): 
  Status("Status",this,status),
  name(name)
{
  int t;
  ext_types[0] = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
  ext_types[3] = (char*) VDKBuilder::ideDefaults.project.prj_ext;
  char* ext = get_extension(name);
  if(ext) 
    {
      char* p = ext+1;
      for(t=0; ext_types[t];t++)
	if(!strcmp(p,ext_types[t]))
	  break;
      if(ext_types[t]) 
	type = t;
      else
	type = unknow_type;
      *ext = '\0';
      VDKBUnit::name = name;
    }
  else type = unknow_type;
}

/*
make an unit if you already know
unit type
 */
VDKBUnit::VDKBUnit(char* name, int type, int status):
  Status("Status",this,status),
  name(name), type(type)
  
{
}
/*
 */
VDKBUnit::~VDKBUnit()
{
}
/*
 */
char* VDKBUnit::ShortName()
{
  char* p = new char [strlen((char*) name)+1 ];
  strcpy(p, (char*) name);
  return get_shortfilename(p);
}
//
char* VDKBUnit::Name(char* name)
{
  if(name)
    VDKBUnit::name = name;
  return (char*) VDKBUnit::name;
}
//
char* VDKBUnit::Header()
{
char* h_ext    = (char*) VDKBuilder::ideDefaults.unit.h_ext;
sprintf(buff,"%s.%s",(char*) name,h_ext);
return buff;
}
//
char* VDKBUnit::Gui()
{
sprintf(buff,"%s.%s",(char*) name,FORM_EXT);
return buff;
}
/*
 */
char* VDKBUnit::GuiSource()
{
char* cc_ext  = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
sprintf(buff,"%s_gui.%s",(char*) name,cc_ext);
return buff;
}
//
//
char* VDKBUnit::Dfm()
{
sprintf(buff,"%s.%s",(char*) name,FORM_EXT);
return buff;
}
//
char* VDKBUnit::DfmHeader()
{
char* h_ext  = (char*) VDKBuilder::ideDefaults.unit.h_ext;
sprintf(buff,"%s_gui.%s",(char*) name,h_ext);
return buff;
}
//
char* VDKBUnit::Source()
{
char* cc_ext   = (char*) VDKBuilder::ideDefaults.unit.cc_ext;
char* ext = NULL;
if((type == source_unit) || (type == project_unit))
  ext = cc_ext;
else
if (type == c_source_unit)
  ext = "c";
sprintf(buff,"%s.%s",(char*) name,ext);
return buff;
}



