/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <stdio.h>
#include <string.h>
/*
owner should
delete returned
address.  (if not NULL)
*/
char* get_path(char* name)
{
  int t;
  char *s = new char[strlen(name)+1], *p;
  strcpy(s,name);
  t = strlen(s)-1;
  p = &s[t];
  for(; t >= 0 && *p != '/'; p--,t--) ;
  if(t)
    {
      s[t] = '\0';
      return s;
    }
  else
    { 
      delete[] s;
      return NULL;
    }
  
}
/*
 */
char* get_shortfilename(char* s)
{
  int t = strlen(s)-1;
  char* p = &s[t];
  for(; (s != p) && (*p != '/'); p--) ;
  return s != p ? ++p : static_cast<char*>(0);
}

char* get_extension(char* s)
{
  int t = strlen(s)-1;
  char* p = &s[t];
  for(; (s != p) && (*p != '.') && (*p != '/'); p--) ;
  return ( s!= p)  && (*p != '/') ? p : static_cast<char*>(0);
}

/*
 */
void  
LoadSection(char* lines,char ** section, int n)
{
  int t = 0;
  char *p = strtok (lines, "$");
  if(p)
    {
      section[t] = new char[strlen(p)+1];
      strcpy(section[t],p); 
    }
  while ( (p = strtok (NULL, "$")) )
    {
      if(t < n )
	{
	  t++;
	  section[t] = new char[strlen(p)+1];
	  strcpy(section[t],p);
	}
      else break;
    } 
  section[++t] = NULL;
  delete[] lines;
}

/*
ExtractWord()
estrae una parola dalla stringa <src> compresa fra
le parole chiave <key1> e <key2> e la mette in <tgt>.
<key1> e <key2> possono anche essere NULL ("")
ma devono essere diverse
*/
char* ExtractWord(
		char* src,
		char* tgt,
		char* key1,
		char* key2) {
	char* p,*beg,*end;
// rifiuta src vuote
	if(! src || !*src ) return (char*) 0;
// trova inizio key1 se null inizio stringa
	beg = *key1 ? strstr(src,key1) : src;
	if(beg)
	  src = beg;
// trova key2 (se nullo va a fine stringa)
	end = *key2 ? strstr(src+1,key2) : beg+strlen(src);
// controlla word isolata
	if(! beg || ! end) return (char*) 0;
// avanza fino alla fine di key1
	beg+= strlen(key1);
// carica tgt
	p = tgt;
	while( beg < end && beg) *p++ = *beg++;
	*p = '\0';
	return tgt;
	}
/*
   get a portion of definition file, between
   section_begin key word and next section_end (excluded).
   Return a buffer pointer (user should destroy it).
 */
char *
ExtractSection (char *buffer, char *section_begin, char* section_end)
{
  char *end, *begin = buffer, *p;
  if (!buffer)
    return buffer;
  else if (!(begin = strstr (buffer, section_begin)))
    return (char *) 0;
  else
    begin += strlen (section_begin);
  if (!(end = strstr (begin, section_end)))
    return (char *) 0;
  else
    p = new char[end - begin + 2];
  strncpy (p, begin, end - begin);
  p[end - begin] = '\0';
  return p;
}


