/*
 * ===========================
 * VDK Builder
 * Version 1.2
 * Revision 0.1
 * May 2000
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if USE_XDB

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str

  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_xtDlg.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_utils.h>
#include <vdk/FileDialog.h>

/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(Vdkb_xtDlgForm,VDKForm);
DEFINE_EVENT_LIST(Vdkb_xtDlgForm,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(Vdkb_xtDlgForm,VDKForm)
  ON_SIGNAL(close,clicked_signal,OncloseClick),
  ON_SIGNAL(addTable,clicked_signal,OnaddTableClick),
  ON_SIGNAL(addIndex,clicked_signal,OnaddIndexClick),
  ON_SIGNAL(editTable,clicked_signal,OneditTableClick),
  ON_SIGNAL(dbTree,select_node_signal,OnSelectNode),
  ON_SIGNAL(removeTable,clicked_signal,OnRemoveClick),
  ON_SIGNAL(dbTree,unselect_node_signal,OnUnselectNode)
END_SIGNAL_MAP

/*
statics
*/
VDKXDatabase* theXdb;
extern VDKBuilder* TheApp;
static char buff[256];
/*
main form GUI setup
*/
void
Vdkb_xtDlgForm::GUISetup(void)
{
  SetSize(400,400);
  Title = _("VDKXDatabase Dialog");
  vbox1 = new VDKBox(this,v_box);
  Add(vbox1,0,1,1,0);
  vbox2 = new VDKBox(this,v_box);
  vbox1->Add(vbox2,0,1,1,0);
  vbox2->BorderWidth(0);
  char* dbtitles[2], *ftitles[4];
  // tricky way for i18n
  dbtitles[0] = _("Tables/Indexes");
  dbtitles[1] = _("Index Key");
  ftitles[0]  = _("Field name");
  ftitles[1]  = _("Type");
  ftitles[2]  = _("Length");
  ftitles[3]  = _("Dec");
  //
  dbTree = new VDKCustomTree(this,2,
			     dbtitles,
			     (GtkSelectionMode) 0);
  dbTree->SetSize(-1,200);
  dbTree->AutoResize = true;
  vbox2->Add(dbTree,0,1,1,0);
  fieldList = new VDKCustomList(this,4,
				ftitles,
				GTK_SELECTION_EXTENDED);
  fieldList->SetSize(-1,100);
  fieldList->AutoResize = true;
  vbox2->Add(fieldList,0,1,1,0);
  separator1 = new VDKSeparator(this,h_separator);
  vbox1->Add(separator1,0,0,0,0);
  hbox3 = new VDKBox(this,h_box);
  hbox3->SetSize(330,30);
  vbox1->Add(hbox3,0,0,0,0);
  hbox3->BorderWidth(0);

  addTable = new VDKCustomButton(this,(char*) NULL,
				 _("Add a table")
				 ,16,(GtkPositionType) 1);
  addTable->SetTip(_("Add a table to xdb"));
  hbox3->Add(addTable,0,1,1,0);

  removeTable = new VDKCustomButton(this,(char*) NULL,
				 _("Remove")
				 ,16,(GtkPositionType) 1);
  removeTable->Enabled=false;
  removeTable->SetTip(_("Remove table or index"));
  hbox3->Add(removeTable,0,1,1,0);

  addIndex = new VDKCustomButton(this,(char*) NULL,
				 _("Add index"),
				 16,(GtkPositionType) 1);
  addIndex->Enabled=false;
  addIndex->SetTip(_("Add an index to table"));
  hbox3->Add(addIndex,0,1,1,0);

  editTable = new VDKCustomButton(this,(char*) NULL,
				  _("Active/inactive")
				  ,16,(GtkPositionType) 1);
  editTable->SetTip(_(
"Setting table \"active\" makes vdkbuilder generate\n\
the code to open the table at run time"));
  editTable->Enabled=false;
  hbox3->Add(editTable,0,1,1,0);

  close = new VDKCustomButton(this,(char*) NULL,
			      _("Close")
			      ,16,(GtkPositionType) 1);
  close->SetTip(_("Close dialog"));
  hbox3->Add(close,0,1,1,0);

  statusbar = new VDKStatusbar(this);
  statusbar->SetSize(330,25);
  Add(statusbar,r_justify,false,false,0);
}
/*
  main form constructor
*/
Vdkb_xtDlgForm::Vdkb_xtDlgForm(VDKForm* owner, char* title):
  VDKForm(owner,title)
{
  Changed = false;
}

/*
  main form destructor
*/
Vdkb_xtDlgForm::~Vdkb_xtDlgForm()
{
}

/*
  main form setup
*/
void
Vdkb_xtDlgForm::Setup(void)
{
  GUISetup();
  // put your code below here
  theXdb = TheApp->theXdb;
  // load tables if any
  LoadTables();
}

/*
 */
static char* node_type = "TI"; // T for tables, I for indices
void
Vdkb_xtDlgForm::LoadTables()
{
  TableList* tlist = theXdb->TList();
  // clears tree
  dbTree->Clear();
  if(!tlist->size())
    {
      statusbar->Push(_("No tables loaded"));
      return;
    }
  TableListIterator li(*tlist);
  dbTree->Freeze();
  for(;li;li++)
    {
      // add each table as root one
      VDKTreeNode node;
      VDKXTable* table = li.current();
      IndexList* nlist = table->NdxList();
      char* dbName = table->Name();
      char* dbKey = table->Active ? (char*) _("ACTIVE") : 
	(char*)_("NOT ACTIVE");
      char* columns[2];
      columns[0] = dbName;
      columns[1] = dbKey;
      node = dbTree->AddNode(columns,(VDKTreeNode) NULL,true,false);
      // sets 'T' as node data
      gtk_ctree_node_set_row_data(GTK_CTREE(dbTree->CustomWidget()), node,
				  (gpointer) &node_type[0]);
      if(node && (nlist->size() > 0) )
	{
	  IndexListIterator ln(*nlist);
	  for(;ln;ln++)
	    {
	      char* ndxName = ln.current()->Name();
	      char* ndxKey = (char*) ln.current()->Key();
	      columns[0] = ndxName;
	      columns[1] = ndxKey;
	      VDKTreeNode index_node = dbTree->AddNode(columns,
				     node,true,true);
	      // sets 'I' as node data
	      gtk_ctree_node_set_row_data(GTK_CTREE(dbTree->CustomWidget()),
					  index_node,
					  (gpointer) &node_type[1]);

	    }
	}
    }
  dbTree->Thaw();
  sprintf(buff,_("%3d tables loaded"),tlist->size());
  statusbar->Push(buff);
}
/*
 */
bool 
Vdkb_xtDlgForm::OnSelectNode(VDKObject* sender)
{
  VDKTreeNode node = dbTree->SelectedNode;
  bool isTable = false;
  if(!node)
    return true;
  else
    {
      char* type = (char*) gtk_ctree_node_get_row_data(
			     GTK_CTREE(dbTree->CustomWidget()), node);
      isTable = *type == 'T';
      addIndex->Enabled = isTable;
      editTable->Enabled = isTable;
      removeTable->Enabled = true;
    }
  fieldList->Clear();
  if(isTable)
    // load fields
    {
      int t = 0;
      char name[11],type[2],length[8],decimal[32];
      char* columns[4];
      xbShort fn = 0;
      VDKXTable* table = NULL;
      char* dbname = dbTree->Key(node);
      table = dbname ? (*theXdb)[dbname] : NULL;
      if(!table)
	return true;
      fn = table->FieldCount();
      for(; t < fn; t++)
	{
	  sprintf(name,"%s",table->GetFieldName(t));
	  columns[0] = name;
	  type[0] = table->GetFieldType(t);
	  type[1] = '\0';
	  columns[1] = type;
	  sprintf(length,"%d",table->GetFieldLen(t));
	  columns[2] = length;
	  sprintf(decimal,"%d",table->GetFieldDecimal(t));
	  columns[3] = decimal;
	  fieldList->AddRow(columns);
	}
    }
  return true;
}
/*
 */
bool 
Vdkb_xtDlgForm::OnUnselectNode(VDKObject* sender)
{
  addIndex->Enabled = false;
  removeTable->Enabled = false;
  editTable->Enabled = false;
  return true;
}
//signal response method
bool
Vdkb_xtDlgForm::OneditTableClick(VDKObject* sender)
{
  VDKTreeNode node = dbTree->SelectedNode;
  if(!node)
    return true;  
  else
    {
      char* dbname = dbTree->Key(node);
      VDKXTable* table = (*theXdb)[dbname];
      // toggle table active flag
      if(table)
	{
	  table->Active = table->Active ? false : true;
	  char* text = table->Active ? (char*)_("ACTIVE") : 
	    (char*) _("NOT ACTIVE");
	  gtk_ctree_node_set_text(GTK_CTREE(dbTree->CustomWidget()),
					    node,1,text);
	  Changed = true;
	}
    }
  return true;
}

//signal response method
bool
Vdkb_xtDlgForm::OnaddIndexClick(VDKObject* sender)
{
  VDKTreeNode node = dbTree->SelectedNode;
  FileStringArray selections;
  VDKXTable* table = NULL;
  char* dbname;
  if(!node)
    return true;
  else
    {
      dbname = dbTree->Key(node);
      table = (*theXdb)[dbname];
    }
  if(!table)
    return true;
  
  VDKFileDialog *dlg = new VDKFileDialog(this,
					&selections,
					(char*) _("VDKXTableIndex opening"));
  dlg->Filter = "*.ndx";
  dlg->ShowModal();
  for( int t = 0; t < selections.size(); t++)
    {
      // store only relative path
      // absolute path will be composed with
      // XDB_DATA_PATH symbolic constant 
      // during code generation
      /*
      char* local = new char[strlen((char*) selections[t])+1];
      strcpy(local,(char*) selections[t]);
      char* relative = get_shortfilename(local);
      */
      VDKXTableIndex *index = new VDKXTableIndex(table,(char*) selections[t]
						 /*relative*/);
      xbShort rc = index->Open();
      if(rc != XB_NO_ERROR)
	table->RemoveIndex((char*) selections[t]/*relative*/);
      else
	{
	  LoadTables();
	  Changed = true;
	}
      //      delete[] local; 
    }
  return true;
}

/*
 */
bool
Vdkb_xtDlgForm::OnRemoveClick(VDKObject* sender)
{
  VDKTreeNode node = dbTree->SelectedNode;
  bool isTable = false;
  if(!node)
    return true;
  else
    {
      char* type = (char*) gtk_ctree_node_get_row_data(
			     GTK_CTREE(dbTree->CustomWidget()), node);
      isTable = *type == 'T';
    }
  if(isTable)
    {
      char* dbname = dbTree->Key(node);
      if(theXdb->RemoveTable(dbname))
	{
	  sprintf(buff,_("Table:%s removed"),dbname);
	  statusbar->Push(buff);
	  LoadTables();
	  Changed = true;
	}
    }
  else
    {
      // get parent node
      VDKTreeNode parent= GTK_CTREE_ROW(node)->parent;
      if(parent)
	{
	  char* ndxname = dbTree->Key(node);
	  char* dbname = dbTree->Key(parent);
	  VDKXTable* table = (*theXdb)[dbname];
	  if(table && table->RemoveIndex(ndxname))
	    {
	      sprintf(buff,_("Index:%s removed"),ndxname);
	      statusbar->Push(buff);
	      LoadTables();
	      Changed = true;
	    }
	}
    }
  return true;
}
//signal response method
bool
Vdkb_xtDlgForm::OnaddTableClick(VDKObject* sender)
{
  FileStringArray selections;
  VDKFileDialog *dlg = new VDKFileDialog(this,
					&selections,
					(char*) _("VDKXTable opening"));
  dlg->Filter = "*.dbf";
  dlg->ShowModal();
  for( int t = 0; t < selections.size(); t++)
    {
      // store only relative path
      // absolute path will be composed with
      // XDB_DATA_PATH symbolic constant 
      // during code generation
      /*
      char* local = new char[strlen((char*) selections[t])+1];
      strcpy(local,(char*) selections[t]);
      char* relative = get_shortfilename(local);
      */
      VDKXTable *table = new VDKXTable(theXdb,selections[t]/*relative*/);
      xbShort rc = table->Open();
      if(rc != XB_NO_ERROR)
	theXdb->RemoveTable(selections[t]/*relative*/);
      else
	{
	  LoadTables();
	  Changed = true;
	}
      //      delete[] local;
    }
  return true;
}

//asks user before closing
extern int  AskUserToSaveFile(char* name);
extern bool SaveXdbOptions(VDKXDatabase* db, char* filename);
bool
Vdkb_xtDlgForm::CanClose(void)
{
  if(Changed)
    {
      VDKBMainForm* vdkb = dynamic_cast<VDKBMainForm*>(Owner());
      if(vdkb)
	{
	  VDKBProjectManager* prjman = vdkb->PrjManager();
	  if(prjman)
	    {
	      VDKBProject* prj = prjman->Project();
	      sprintf(buff,"%s.prj.xdb",(char*) prj->PathName);
	      if(AskUserToSaveFile(buff))
		{
		  //		  vdkb->Changed = true;
		  SaveXdbOptions(theXdb, (char*) prj->PathName);
		}
	    }
	}
    }
  return true;
}

//signal response method
bool
Vdkb_xtDlgForm::OncloseClick(VDKObject* sender)
{
  Close();
  return true;
}

#endif




