/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1998-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#ifdef TEST

#include <vslib.h>

int list( const char* o, const char* p, const struct stat* st, int is_link, int flag )
{
  char *flags[] = { "??", "--", "[]", "<>", "!!" };
  char *links[] = { "--", "LL" };
  
  //if ( flag == FTWALK_DX ) return 0;
  
  printf( "%s %s %12ld %s\n", flags[flag], links[is_link], st->st_size, p );
  return 0;
}

int main( int argc, char* argv[] )
{

  VTrie tr;
  VArray va;
  
  tr.set( "tralala", "data1" );
  tr.set( "opala", "data2" );
  tr.set( "keynext", "data3" );

  va.add( "this" );
  va.add( "just" );
  va.add( "test" );
  va.add( "simple" );

  tr.merge( &va );
  
  va.zap;

  int i = tr.keys( &va );

  printf( "keys = %d\n", i );
  
  for( i = 0; i < va.count(); i++ )
    {
    printf( "%d -> %s (%s)\n", i, va[i], tr[ va[i] ] );
    }

  printf( "--------------------\n" );
  VArray v1;
  
  v1.merge( &tr );
  for( i = 0; i < v1.count(); i++ )
    {
    printf( "%d -> %s\n", i, v1[i] );
    }
  
  
  printf( "adler32 = %X\n", str_adler32( "This is a test" ));
  return 0;
}
#endif

// eof vslib.cpp
