/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ABSTRACTROWFILTER_H
#define ABSTRACTROWFILTER_H

#include <QObject>

namespace WebIssues
{

/**
* Abstract filter for filtering table rows.
*
* The inherited class must implement the filterRow() method.
*
* @see MultiTableModel
*/
class AbstractRowFilter : public QObject
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    */
    AbstractRowFilter( QObject* parent );

    /**
    * Destructor.
    */
    ~AbstractRowFilter();

public:
    /**
    * Filter the given row.
    *
    * @param id Identifier of the row to filter.
    *
    * @return @c true if the row should be included, @c false if it should be hidden.
    */
    virtual bool filterRow( int id ) = 0;

signals:
    /**
    * Emitted when filter conditions were changed.
    */
    void conditionsChanged();
};

}

#endif
