/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef VALUEEDITORFACTORY_H
#define VALUEEDITORFACTORY_H

class QObject;
class QWidget;

class DefinitionInfo;
class AbstractValueEditor;

/**
* @brief Function creating delegates for editing attribute values.
*/
class ValueEditorFactory
{
public:
    /**
    * @brief Create an attribute value editor delegate for given attribute definition.
    *
    * @param info Attribute definition.
    *
    * @param projectId Optional project identifier for attribute value context.
    *
    * @param parent Parent object of the editor delegate.
    *
    * @param parentWidget Parent widget of the editor widget.
    *
    * @return The created object or @c NULL if the definition is invalid.
    */
    static AbstractValueEditor* createValueEditor( const DefinitionInfo& info, int projectId,
                                                   QObject* parent, QWidget* parentWidget );
};

#endif
