/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef PREFERENCESDATA_H
#define PREFERENCESDATA_H

#include <QMap>
#include <QString>

/**
* Structure storing preferences of a user.
*/
class PreferencesData
{
public:
    /**
    * Constructor.
    */
    PreferencesData();

    /**
    * Destructor.
    */
    ~PreferencesData();

public:
    /**
    * Return the value of the given preference.
    */
    QString value( const QString& key ) const;

    /**
    * Return @c true if the preferences are empty.
    */
    bool isEmpty() const;

    /**
    * Set the value of a preference.
    */
    void setValue( const QString& key, const QString& value );

    /**
    * Clear all preferences.
    */
    void clear();

    /**
    * Create a copy of the preferences containing only values different than the other ones.
    */
    PreferencesData compareWith( const PreferencesData& other ) const;

protected:
    QMap<QString, QString> m_map;
};

#endif
