/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef SSLERRORSDIALOG_H
#define SSLERRORSDIALOG_H

#if defined( HAVE_OPENSSL )

#include <QDialog>
#include <QSslError>

class QListWidget;
class QCheckBox;

/**
* Dialog for showing SSL connection errors.
*/
class SslErrorsDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    SslErrorsDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~SslErrorsDialog();

public:
    /**
    * Set the list of errors to display.
    */
    void setErrors( const QList<QSslError>& errors );

    /**
    * Set the list of associated certificates.
    */
    void setCertificates( const QList<QSslCertificate>& certificates );

public: // overrides
    void accept();

private slots:
    void showCertificates();

private:
    QListWidget* m_list;

    QPushButton* m_certificatesButton;

    QCheckBox* m_acceptCheckBox;

    QList<QSslCertificate> m_certificates;
};

#endif // defined( HAVE_OPENSSL )

#endif
