/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ISSUEHISTORYPROVIDER_H
#define ISSUEHISTORYPROVIDER_H

#include <QObject>
#include <QList>

class QDateTime;

class IssueHistoryWriter;

/**
* Class providing issue history to the IssueHistoryWriter.
*
* This class extracts the history of an issue, formats it into localized text
* and outputs it to the IssueHistoryWriter.
*/
class IssueHistoryProvider : public QObject
{
    Q_OBJECT
public:
    /**
    * Default constructor.
    */
    IssueHistoryProvider();

    /**
    * Destructor.
    */
    ~IssueHistoryProvider();

public:
    /**
    * Extract the history of the given issue.
    */
    void extractIssueHistory( int issueId );

    /**
    * Output the extracted history to the writer.
    */
    void write( IssueHistoryWriter* writer );

private:
    QString headerCreated( int userId, const QDateTime& date );
    QString headerModified( int userId, const QDateTime& date );
    QString headerComment( int commentId, int userId, const QDateTime& date );
    QString headerAttachment( int attachmentId, int userId, const QDateTime& date );

    QString itemInitialName( const QString& name );
    QString itemChange( int attributeId, const QString& oldValue, const QString& newValue );
    QString itemAttachment( int attachmentId, const QString& name, int size, const QString& description );

private:
    int m_issueId;

    QList<int> m_items;

    QString m_initialName;

    IssueHistoryWriter* m_writer;
};

#endif
