/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef PANEWIDGET_H
#define PANEWIDGET_H

#include <QStackedWidget>

class QLabel;

/**
* Pane for displaying a widget or a placeholder text.
*/
class PaneWidget : public QStackedWidget
{
    Q_OBJECT
public:
    /**
    * Conctructor.
    *
    * @param parent The parent widget.
    */
    PaneWidget( QWidget* parent );

    /**
    * Destructor.
    */
    ~PaneWidget();

public:
    /*
    * Set text displayed when widget is hidden.
    */
    void setPlaceholderText( const QString& text );

    /**
    * Set the widget contained in this pane.
    *
    * The PaneWidget takes ownership of this widget.
    */
    void setMainWidget( QWidget* widget );

    /**
    * Show or hide the contained widget.
    */
    void setMainWidgetVisible( bool visible );

private:
    QLabel* m_label;
    QWidget* m_labelWidget;
    QWidget* m_mainWidget;
};

#endif
