/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef STATUSBAR_H
#define STATUSBAR_H

#include <QStatusBar>

class QLabel;

/**
* A status bar with status icon and label and an optional summary field.
*/
class StatusBar : public QStatusBar
{
    Q_OBJECT
public:
    /**
    * Conctructor.
    *
    * @param parent The parent widget.
    */
    StatusBar( QWidget* parent );

    /**
    * Destructor.
    */
    ~StatusBar();

public:
    /**
    * Show a message with an information icon.
    */
    void showInfo( const QString& text );

    /**
    * Show a message with a warning icon.
    */
    void showWarning( const QString& text );

    /**
    * Show a message with a busy icon.
    */
    void showBusy( const QString& text );

public slots:
    /**
    * Show a status message in the status bar.
    */
    void showStatus( const QPixmap& pixmap, const QString& text );

    /**
    * Show a summary field in the status bar.
    *
    * If the summary text is empty, the field is hidden.
    */
    void showSummary( const QPixmap& pixmap, const QString& text );

private:
    QLabel* m_pixmap;
    QLabel* m_label;

    QLabel* m_summaryPixmap;
    QLabel* m_summaryLabel;
};

#endif
