/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_LISTENERS_H
#define _WF_LISTENERS_H

#include <iostream>
#include <list>

#include "wflistener.h"

/**
 * listeners: a list of listeners.
 */
class wf_listeners {
 public:
  wf_listeners() : elems() {}
  virtual ~wf_listeners() {}
  wf_listeners(const wf_listeners&);
  wf_listeners& operator=(const wf_listeners&);

  /** local probe of listening services (for tcp or udp only)  */
  bool probe_local(int proto);

  /** local probe for both tcp and udp listening services */
  bool probe_local();

  ostream& print(ostream& os) const;

 public:
  list<wf_listener*> elems;
 private:
#ifdef linux
  bool probe_local_linux(int proto);
#elif defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
  bool probe_local_bsd(int proto);
#endif
};

#endif
