#!/bin/bash
#
# Master script to try and find out where we are
# by Andrew McMillan, Catalyst IT Ltd, (c) 1999-2001 licensed
# for use under the Gnu GPL version 2
#
LOCATION=${1:-"unknown"}
DEVICE=${2:-"eth0"}

# everything is relative to this directory, so we should be movable, if
# necessary to meet some file location standards.  I think this is a good
# place anyway though.  We put our 'helper' scripts in /usr/share/whereami
# so we ensure that directory is on the path when we execute the script
# we have constructed for this location.

cd /etc/whereami

if [ -f iam ]; then LASTLOCN=`tail -n 1 iam`; fi

if [ "$LOCATION" = "unknown" ]; then
  LOCATION=$LASTLOCN

  if [ -f iwillbe ]; then rm iwillbe; fi
  # 
  # Run all the scripts in the ./tests directory until one of them sets 'LOCATED'
  LOCATED=0
  for TESTSCRIPT in tests/* ;
  do
    # echo "Testing $TESTSCRIPT"
    . $TESTSCRIPT
    if (( $LOCATED )) ; then break; fi
  done
  if [ -f iwillbe ]; then LOCATION=`tail -n 1 iwillbe`; fi
else
  echo "$LOCATION" >iwillbe
fi

# Start the new script setting appropriate variables for old
# and new locations.
echo "#!$SHELL" >whereiam.sh
echo "LASTLOCN=$LASTLOCN" >>whereiam.sh
echo "LOCATION=$LOCATION" >>whereiam.sh

unset PATTERN
LASTPAT=0
if [[ "$LASTLOCN" != "$LOCATION" ]]
then
  if [ -f iam ]; then
    # savelog just gives us a history of the locations we've been at
    savelog iwas >>/dev/null
    mv iam iwas
  fi
  [ -f iwillbe ] && mv iwillbe iam

  # Get the bits from the config file for moving from the last location
  PATTERN="+"
  LASTPAT=1
fi

# Get the bits from the config file for being at the current location
PATTERN="(^[$PATTERN=]$LOCATION)|(^[+=-]any)"
if (( $LASTPAT > 0 )) ; then PATTERN="$PATTERN|(^-$LASTLOCN)"; fi
egrep "$PATTERN" whereami.conf | cut --delimiter=\  --fields=2- >>whereiam.sh

echo "Running script from $LASTLOCN to $LOCATION"
PATH=$PATH:/usr/share/whereami
. ./whereiam.sh

