/* cursorops.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: cursorops.cc,v 1.24 2005/10/19 18:06:21 ralf Exp $ */

#include "cursorops.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"
#include "wpucontext.h"
#include "ownop.h"

/******
 RowUp
*******/

const char *RowUp::name="RowUp";

bool RowUp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *RowUp::getName()
{
  return name;
}

RowUp::RowUp() : FunctionProto()
{
}

RowUp::~RowUp()
{
}

RowUp *RowUp::duplicate() const
{
  RowUp *ta=new RowUp();
  return ta;
}

int RowUp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->up();
        }
      }
    }
  }
  return 0;
}

const char *RowUp::getDescription()
{
  return catalog.getLocaleCom(5);
}

/*************
 Ende RowUp
**************/

/********
 RowDown
*********/

const char *RowDown::name="RowDown";

bool RowDown::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *RowDown::getName()
{
  return name;
}

RowDown::RowDown() : FunctionProto()
{
}

RowDown::~RowDown()
{
}

RowDown *RowDown::duplicate() const
{
  RowDown *ta=new RowDown();
  return ta;
}

int RowDown::run( WPUContext *wpu, ActionMessage *msg)
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->down();
        }
      }
    }
  }
  return 0;
}

const char *RowDown::getDescription()
{
  return catalog.getLocaleCom(6);
}

/*************
 Ende RowDown
**************/

/********
 FirstRow
*********/

const char *FirstRow::name="FirstRow";

bool FirstRow::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *FirstRow::getName()
{
  return name;
}

FirstRow::FirstRow() : FunctionProto()
{
}

FirstRow::~FirstRow()
{
}

FirstRow *FirstRow::duplicate() const
{
  FirstRow *ta=new FirstRow();
  return ta;
}

int FirstRow::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->top();
        }
      }
    }
  }
  return 0;
}

const char *FirstRow::getDescription()
{
  return catalog.getLocaleCom(9);
}

/*************
 Ende FirstRow
**************/

/********
 LastRow
*********/

const char *LastRow::name="LastRow";

bool LastRow::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *LastRow::getName()
{
  return name;
}

LastRow::LastRow() : FunctionProto()
{
}

LastRow::~LastRow()
{
}

LastRow *LastRow::duplicate() const
{
  LastRow *ta=new LastRow();
  return ta;
}

int LastRow::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->last();
        }
      }
    }
  }
  return 0;
}

const char *LastRow::getDescription()
{
  return catalog.getLocaleCom(10);
}

/*************
 Ende LastRow
**************/

/******
 PageUp
*******/

const char *PageUp::name="PageUp";

bool PageUp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *PageUp::getName()
{
  return name;
}

PageUp::PageUp() : FunctionProto()
{
}

PageUp::~PageUp()
{
}

PageUp *PageUp::duplicate() const
{
  PageUp *ta=new PageUp();
  return ta;
}

int PageUp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->pageup();
        }
      }
    }
  }
  return 0;
}

const char *PageUp::getDescription()
{
  return catalog.getLocaleCom(11);
}

/*************
 Ende PageUp
**************/

/******
 PageDown
*******/

const char *PageDown::name="PageDown";

bool PageDown::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *PageDown::getName()
{
  return name;
}

PageDown::PageDown() : FunctionProto()
{
}

PageDown::~PageDown()
{
}

PageDown *PageDown::duplicate() const
{
  PageDown *ta=new PageDown();
  return ta;
}

int PageDown::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->pagedown();
        }
      }
    }
  }
  return 0;
}

const char *PageDown::getDescription()
{
  return catalog.getLocaleCom(12);
}

/*************
 Ende PageDown
**************/

/******
 SelectOp
*******/

const char *SelectOp::name="SelectOp";

bool SelectOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SelectOp::getName()
{
  return name;
}

SelectOp::SelectOp() : FunctionProto()
{
}

SelectOp::~SelectOp()
{
}

SelectOp *SelectOp::duplicate() const
{
  SelectOp *ta=new SelectOp();
  return ta;
}

int SelectOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->select();
        }
      }
    }
  }
  return 0;
}

const char *SelectOp::getDescription()
{
  return catalog.getLocaleCom(13);
}

/*************
 Ende SelectOp
**************/

/******
 SelectAllOp
*******/

const char *SelectAllOp::name="SelectAllOp";

bool SelectAllOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SelectAllOp::getName()
{
  return name;
}

SelectAllOp::SelectAllOp() : FunctionProto()
{
}

SelectAllOp::~SelectAllOp()
{
}

SelectAllOp *SelectAllOp::duplicate() const
{
  SelectAllOp *ta=new SelectAllOp();
  return ta;
}

int SelectAllOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->selectall();
        }
      }
    }
  }
  return 0;
}

const char *SelectAllOp::getDescription()
{
  return catalog.getLocaleCom(14);
}

/*************
 Ende SelectAllOp
**************/

/******
 SelectNoneOp
*******/

const char *SelectNoneOp::name="SelectNoneOp";

bool SelectNoneOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *SelectNoneOp::getName()
{
  return name;
}

SelectNoneOp::SelectNoneOp() : FunctionProto()
{
}

SelectNoneOp::~SelectNoneOp()
{
}

SelectNoneOp *SelectNoneOp::duplicate() const
{
  SelectNoneOp *ta=new SelectNoneOp();
  return ta;
}

int SelectNoneOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->selectnone();
        }
      }
    }
  }
  return 0;
}

const char *SelectNoneOp::getDescription()
{
  return catalog.getLocaleCom(15);
}

/*************
 Ende SelectNoneOp
**************/

/******
  InvertAllOp
*******/

const char *InvertAllOp::name="InvertAllOp";

bool InvertAllOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *InvertAllOp::getName()
{
  return name;
}

InvertAllOp::InvertAllOp() : FunctionProto()
{
}

InvertAllOp::~InvertAllOp()
{
}

InvertAllOp *InvertAllOp::duplicate() const
{
  InvertAllOp *ta=new InvertAllOp();
  return ta;
}

int InvertAllOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->invertall();
        }
      }
    }
  }
  return 0;
}

const char *InvertAllOp::getDescription()
{
  return catalog.getLocaleCom(16);
}

/*************
 Ende InvertAllOp
**************/

/******
  ParentDirOp
*******/

const char *ParentDirOp::name="ParentDirOp";

bool ParentDirOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *ParentDirOp::getName()
{
  return name;
}

ParentDirOp::ParentDirOp() : FunctionProto()
{
}

ParentDirOp::~ParentDirOp()
{
}

ParentDirOp *ParentDirOp::duplicate() const
{
  ParentDirOp *ta=new ParentDirOp();
  return ta;
}

int ParentDirOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  NormalMode *nm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          nm1->parent();
        }
      }
    }
  }
  return 0;
}

const char *ParentDirOp::getDescription()
{
  return catalog.getLocaleCom(17);
}

/*************
 Ende ParentDirOp
**************/

/******
  EnterDirOp
*******/

/* Bei normalen Aufruf: aktiven Eintrag benutzen
   Bei DND: Element (muesste aktives sein) in Ziel (muss erst erkannt werden) darstellen
   Wenn diese Op einen Pfad hat (also nicht leer), dann diesen darstellen (also unabhaengig
     vom Eintrag */

const char *EnterDirOp::name="EnterDirOp";

bool EnterDirOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *EnterDirOp::getName()
{
  return name;
}

EnterDirOp::EnterDirOp() : FunctionProto()
{
  dir=(char*)_allocsafe(1);
  dir[0]=0;
  enterdirmode=ENTERDIROP_ACTIVE;
  hasConfigure = true;
}

EnterDirOp::~EnterDirOp()
{
  _freesafe(dir);
}

EnterDirOp *EnterDirOp::duplicate() const
{
  EnterDirOp *ta=new EnterDirOp();
  _freesafe(ta->dir);
  ta->dir=dupstring(dir);
  ta->enterdirmode=enterdirmode;
  return ta;
}

int EnterDirOp::run( WPUContext *wpu, ActionMessage *msg )
{
  Lister *l1;
  ListerMode *lm1;
  NormalMode *nm1;
  int erg;
  char *buttonstr,*return_str, *tstr;
  const char *textstr;

  if(msg->mode==msg->AM_MODE_DNDACTION) {
    l1 = msg->dndmsg->getDestLister();
    if(l1!=NULL) {
      // Element in l1 darstellen
      l1->switch2Mode(0);
      lm1=l1->getActiveMode();
      if(lm1!=NULL) {
        if(lm1->isType("NormalMode")==true) {
          nm1=(NormalMode*)lm1;
          FileEntry *fe = msg->dndmsg->getFE();
	  if ( ( fe != NULL ) && ( fe->fullname != NULL ) ) {
	    tstr = dupstring( fe->fullname );
            nm1->enterDir( tstr );
	    _freesafe( tstr );
	  }
        }
      }
    }
  } else {
    if(enterdirmode==ENTERDIROP_SPECIAL) {
      if(strlen(dir)>0) {
        l1 = msg->getWorker()->getActiveLister();
        if(l1!=NULL) {
          l1->switch2Mode(0);
          lm1=l1->getActiveMode();
          if(lm1!=NULL) {
            if(lm1->isType("NormalMode")==true) {
              nm1=(NormalMode*)lm1;
              
              tstr = wpu->parse( dir, a_max( EXE_STRING_LEN - 1024, 256 ), false );
              if ( tstr != NULL ) {
                nm1->enterDir( tstr );
                _freesafe( tstr );
              }
            }
          }
        }
      }
    } else if(enterdirmode==ENTERDIROP_REQUEST) {
      Requester *req=new Requester( msg->getWorker()->getAGUIX());
      textstr=catalog.getLocale(290);
      buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                  strlen(catalog.getLocale(8))+1);
      sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                                catalog.getLocale(8));
      erg=req->string_request(catalog.getLocale(123),textstr,"",buttonstr,&return_str);
      _freesafe(buttonstr);
      if((erg==0)&&(strlen(return_str)>0)) {
        l1 = msg->getWorker()->getActiveLister();
        if(l1!=NULL) {
          l1->switch2Mode(0);
          lm1=l1->getActiveMode();
          if(lm1!=NULL) {
            if(lm1->isType("NormalMode")==true) {
              nm1=(NormalMode*)lm1;
              nm1->enterDir(return_str);
            }
          }
        }
      }
      _freesafe(return_str);
      delete req;
    } else {
      // here we need the help of NormalMode
      l1 = msg->getWorker()->getActiveLister();
      if(l1!=NULL) {
        lm1=l1->getActiveMode();
        if(lm1!=NULL) {
          if(lm1->isType("NormalMode")==true) {
            nm1=(NormalMode*)lm1;
            if(enterdirmode==ENTERDIROP_ACTIVE) {
              nm1->enterDirActive();
            } else {
              nm1->setActiveDir2Other();
            }
          }
        }
      }
    }
  }
  return 0;
}

const char *EnterDirOp::getDescription()
{
  return catalog.getLocaleCom(18);
}

int EnterDirOp::configure()
{
  AGUIX *aguix = Worker::getAGUIX();
  AWindow *win;
  CycleButton *rcyb;
  StringGadget *sg;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  
  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(18))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(18));
  win = new AWindow( aguix, 10, 10, 10, 10, 0, tstr );
  win->create();
  _freesafe(tstr);

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 0 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );

  ac1_1->add( new Text( aguix, 0, 0, catalog.getLocale( 317 ), 1 ), 0, 0, cfix );
  rcyb = (CycleButton*)ac1_1->add( new CycleButton( aguix, 0, 0, 100, 1, 0, 0 ), 1, 0, cincw );
  rcyb->addOption(catalog.getLocale(318));
  rcyb->addOption(catalog.getLocale(319));
  rcyb->addOption(catalog.getLocale(320));
  rcyb->addOption(catalog.getLocale(321));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());
  switch(enterdirmode) {
    case ENTERDIROP_ACTIVE2OTHER:
      rcyb->setOption(1);
      break;
    case ENTERDIROP_SPECIAL:
      rcyb->setOption(2);
      break;
    case ENTERDIROP_REQUEST:
      rcyb->setOption(3);
      break;
    default:
      rcyb->setOption(0);
      break;
  }
  ac1_1->readLimits();
  
  AContainer *ac1_2 = ac1->add( new AContainer( win, 4, 1 ), 0, 1 );
  ac1_2->setMinSpace( 0 );
  ac1_2->setMaxSpace( 0 );
  ac1_2->setBorderWidth( 0 );

  ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 322 ), 1 ), 0, 0, cfix );
  ac1_2->setMinWidth( 5, 1, 0 );
  ac1_2->setMaxWidth( 5, 1, 0 );
  sg = (StringGadget*)ac1_2->add( new StringGadget( aguix, 0, 0, 100, dir, 0 ), 2, 0, cincw );
  Button *sgb = (Button*)ac1_2->add( new Button( aguix,
						 0,
						 0,
						 "F",
						 1,
						 0,
						 0 ), 3, 0, cfix );
  sgb->resize( sgb->getWidth(), sg->getHeight() );
  ac1_2->readLimits();

  AContainer *ac1_3 = ac1->add( new AContainer( win, 2, 1 ), 0, 2 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( -1 );
  ac1_3->setBorderWidth( 0 );
  Button *okb =(Button*)ac1_3->add( new Button( aguix,
                                                0,
                                                0,
                                                catalog.getLocale( 11 ),
                                                1,
                                                0,
                                                0 ), 0, 0, cfix );
  Button *cb = (Button*)ac1_3->add( new Button( aguix,
						0,
						0,
						catalog.getLocale( 8 ),
						1,
						0,
						0 ), 1, 0, cfix );

  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          else if ( msg->button.button == sgb ) {
            OwnOp *o;
            
            o = new OwnOp();
            tstr = o->getFlag();
            delete o;
            if ( tstr != NULL ) {
              sg->insertAtCursor( tstr );
              _freesafe( tstr );
            }
          }
          break;
        case AG_STRINGGADGET_DEACTIVATE:
          rcyb->setOption(2);
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    switch(rcyb->getSelectedOption()) {
      case 1:
        enterdirmode=ENTERDIROP_ACTIVE2OTHER;
        break;
      case 2:
        enterdirmode=ENTERDIROP_SPECIAL;
        break;
      case 3:
        enterdirmode=ENTERDIROP_REQUEST;
        break;
      default:
        enterdirmode=ENTERDIROP_ACTIVE;
        break;
    }
    _freesafe(dir);
    dir=dupstring(sg->getText());
  }
  
  delete win;

  return endmode;
}

bool EnterDirOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  WConfig::configPutPairString( fh, "dir", dir );
  switch ( enterdirmode ) {
    case ENTERDIROP_ACTIVE2OTHER:
      WConfig::configPutPair( fh, "mode", "active2other" );
      break;
    case ENTERDIROP_SPECIAL:
      WConfig::configPutPair( fh, "mode", "special" );
      break;
    case ENTERDIROP_REQUEST:
      WConfig::configPutPair( fh, "mode", "request" );
      break;
    default:
      WConfig::configPutPair( fh, "mode", "active" );
  }
  return true;
}

void EnterDirOp::setMode(enterdir_t nv)
{
  enterdirmode=nv;
}

void EnterDirOp::setDir(const char* ndir)
{
  if(dir!=NULL) _freesafe(dir);
  dir=dupstring(ndir);
}

/*************
 Ende EnterDirOp
**************/

