/* request.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: request.cc,v 1.17 2002/03/18 01:14:46 ralf Exp $ */

#include "request.h"
#include "aguix.h"
#include "awindow.h"
#include "button.h"
#include "text.h"
#include "message.h"
#include "stringgadget.h"

Requester::Requester(AGUIX *parent)
{
  aguix=parent;
}

Requester::~Requester()
{
}

int Requester::request(const char *title,const char *text,const char *buttons)
{
  int i;
  Button **buts;
  int w,h,lines,nbuttons;
  char **liness;
  lines=createLines(text,&liness);
  char **buttonss;
  nbuttons=createLines(buttons,&buttonss);
  w=0;
  for(i=0;i<lines;i++) {
    if((int)strlen(liness[i])>w) w=(int)strlen(liness[i]);
  }
  w*=aguix->getCharWidth();
  w+=20;
  int w2;
  w2=10;
  for(i=0;i<nbuttons;i++) {
    w2+=(((int)strlen(buttonss[i]))+2)*aguix->getCharWidth();
    w2+=10;
  }
  if(w2>w) w=w2;
  h=lines*(aguix->getCharHeight()+5);
  h+=5+20+5;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,title);
  int dh=aguix->getCharHeight()+5,ty;
  Text *ttext;
  ty=5;
  for(i=0;i<lines;i++) {
    ttext=(Text*)win->add(new Text(aguix,10,ty,liness[i],1));
    ty+=dh;
  }
  int dx=10;
  buts=(Button**)_allocsafe(nbuttons*sizeof(Button*));
  if(nbuttons==1) {
    int dw=(((int)strlen(buttonss[0]))+2)*aguix->getCharWidth();
    buts[0]=(Button*)win->add(new Button(aguix,w/2-dw/2,ty,dw,buttonss[0],1,0,0));
    ty+=buts[0]->getHeight()+5;
  } else {
    for(i=0;i<(nbuttons-1);i++) {
      buts[i]=(Button*)win->add(new Button(aguix,dx,ty,(((int)strlen(buttonss[i]))+2)*aguix->getCharWidth(),buttonss[i],1,0,i));
      dx+=(((int)strlen(buttonss[i]))+2)*aguix->getCharWidth()+10;
    }
    int dw=(((int)strlen(buttonss[nbuttons-1]))+2)*aguix->getCharWidth();
    buts[nbuttons-1]=(Button*)win->add(new Button(aguix,w-10-dw,ty,dw,buttonss[nbuttons-1],1,0,nbuttons-1));
    ty+=buts[nbuttons-1]->getHeight()+5;
  }
  AGUIX::scaleElementsW( w, 10, 10, -1, false, false, (GUIElement**)buts, nbuttons );
  h=ty;
  win->resize(w,h);
  //  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->centerScreen();
  win->show();
  AGMessage *msg;
  int endmode=-1;
  bool firstkey=true;
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=nbuttons-1;
          break;
        case AG_BUTTONCLICKED:
	  for(i=0;i<nbuttons;i++) {
	    if(msg->button.button==buts[i]) {
	      endmode=i;
	      break;
	    }
	  }
          break;
	case AG_KEYRELEASED:
	  if((win->isParent(msg->key.window,false)==true)&&(firstkey==false)) {
	    switch(msg->key.key) {
	      case XK_KP_Enter:
	      case XK_Return:
	        endmode=0;
		break;
	      case XK_Escape:
	        endmode=nbuttons-1;
		break;
	      case XK_F1:
	        endmode=0;
	        break;
	      case XK_F2:
	        endmode=1;
		if(endmode>=nbuttons) endmode=nbuttons-1;
	        break;
	      case XK_F3:
	        endmode=2;
		if(endmode>=nbuttons) endmode=nbuttons-1;
	        break;
	      case XK_F4:
	        endmode=3;
		if(endmode>=nbuttons) endmode=nbuttons-1;
	        break;
	      case XK_F5:
	        endmode=4;
		if(endmode>=nbuttons) endmode=nbuttons-1;
	        break;
	      case XK_F6:
	        endmode=5;
		if(endmode>=nbuttons) endmode=nbuttons-1;
	        break;
	      case XK_F7:
	        endmode=6;
		if(endmode>=nbuttons) endmode=nbuttons-1;
	        break;
	      case XK_F8:
	        endmode=7;
		if(endmode>=nbuttons) endmode=nbuttons-1;
	        break;
	      case XK_F9:
	        endmode=8;
		if(endmode>=nbuttons) endmode=nbuttons-1;
	        break;
	      case XK_F10:
	        endmode=9;
		if(endmode>=nbuttons) endmode=nbuttons-1;
	        break;
	    }
	  }
	  break;
        case AG_KEYPRESSED:
	  firstkey=false;
	  break;
        case AG_SIZECHANGED:
	  for ( i = 0; i < nbuttons; i++ ) {
	    buts[i]->move( buts[i]->getX(), msg->size.newh - win->getBorderWidth() - buts[i]->getHeight() );
	  }
	  AGUIX::scaleElementsW( msg->size.neww, 10, 10, -1, false, false, (GUIElement**)buts, nbuttons );
	  break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  win->close();
  delete win;
  for(i=0;i<lines;i++) _freesafe(liness[i]);
  for(i=0;i<nbuttons;i++) _freesafe(buttonss[i]);
  _freesafe(liness);
  _freesafe(buttonss);
  _freesafe(buts);
  return endmode;
}

int Requester::string_request(char *title,char *text,const char *default_str,char *buttons,char **return_str)
{
  Button **buts;
  int w,h,lines,nbuttons;
  char **liness;
  lines=createLines(text,&liness);
  char **buttonss;
  StringGadget *sg;
  int i;
  
  nbuttons=createLines(buttons,&buttonss);
  w=0;
  for(i=0;i<lines;i++) {
    if((int)strlen(liness[i])>w) w=(int)strlen(liness[i]);
  }
  w*=aguix->getCharWidth();
  w+=20;
  int w2;
  w2=10;
  for(i=0;i<nbuttons;i++) {
    w2+=(((int)strlen(buttonss[i]))+2)*aguix->getCharWidth();
    w2+=10;
  }
  if(w2>w) w=w2;
  h=lines*(aguix->getCharHeight()+5);
  h+=5+20+5;
  h+=5+aguix->getCharHeight()+8+5;
  AWindow *win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,title);
  int dh=aguix->getCharHeight()+5,ty;
  ty=5;
  for(i=0;i<lines;i++) {
    win->add(new Text(aguix,10,ty,liness[i],1));
    ty+=dh;
  }
  sg=(StringGadget*)win->add(new StringGadget(aguix,10,ty,w-20,default_str,0));
  ty+=sg->getHeight()+5;
  int dx=10;
  buts=(Button**)_allocsafe(nbuttons*sizeof(Button*));
  if(nbuttons==1) {
    int dw=(((int)strlen(buttonss[0]))+2)*aguix->getCharWidth();
    buts[0]=(Button*)win->add(new Button(aguix,w/2-dw/2,ty,dw,buttonss[0],1,0,0));
    ty+=buts[0]->getHeight()+5;
  } else {
    for(i=0;i<(nbuttons-1);i++) {
      buts[i]=(Button*)win->add(new Button(aguix,dx,ty,(((int)strlen(buttonss[i]))+2)*aguix->getCharWidth(),buttonss[i],1,0,i));
      dx+=(((int)strlen(buttonss[i]))+2)*aguix->getCharWidth()+10;
    }
    int dw=(((int)strlen(buttonss[nbuttons-1]))+2)*aguix->getCharWidth();
    buts[nbuttons-1]=(Button*)win->add(new Button(aguix,w-10-dw,ty,dw,buttonss[nbuttons-1],1,0,nbuttons-1));
    ty+=buts[nbuttons-1]->getHeight()+5;
  }
  AGUIX::scaleElementsW( w, 10, 10, -1, false, false, (GUIElement**)buts, nbuttons );
  h=ty;
  sg->activate();
  win->resize(w,h);
  //win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->centerScreen();
  win->show();
  AGMessage *msg;
  int endmode=-1;
  bool firstkey=true;
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=nbuttons-1;
          break;
        case AG_BUTTONCLICKED:
	  for(i=0;i<nbuttons;i++) {
	    if(msg->button.button==buts[i]) {
	      endmode=i;
	      break;
	    }
	  }
          break;
	case AG_STRINGGADGET_OK:
	  if(msg->stringgadget.sg==sg) endmode=0;
	  break;
	case AG_STRINGGADGET_CANCEL:
	  if(msg->stringgadget.sg==sg) endmode=nbuttons-1;
	  break;
	case AG_KEYRELEASED:
	  if((win->isParent(msg->key.window,false)==true)&&(firstkey==false)) {
	    // key release only accept when not first key we get
	    // means a key is pressed when we started and if we use this
	    // key it could confuse the user
	    switch(msg->key.key) {
	      case XK_KP_Enter:
	      case XK_Return:
	        endmode=0;
		break;
	      case XK_Escape:
	        endmode=nbuttons-1;
		break;
	      case XK_F1:
	        endmode=0;
	        break;
	      case XK_F2:
	        endmode=1;
		if(endmode>=nbuttons) endmode=-1;
	        break;
	      case XK_F3:
	        endmode=2;
		if(endmode>=nbuttons) endmode=-1;
	        break;
	      case XK_F4:
	        endmode=3;
		if(endmode>=nbuttons) endmode=-1;
	        break;
	      case XK_F5:
	        endmode=4;
		if(endmode>=nbuttons) endmode=-1;
	        break;
	      case XK_F6:
	        endmode=5;
		if(endmode>=nbuttons) endmode=-1;
	        break;
	      case XK_F7:
	        endmode=6;
		if(endmode>=nbuttons) endmode=-1;
	        break;
	      case XK_F8:
	        endmode=7;
		if(endmode>=nbuttons) endmode=-1;
	        break;
	      case XK_F9:
	        endmode=8;
		if(endmode>=nbuttons) endmode=-1;
	        break;
	      case XK_F10:
	        endmode=9;
		if(endmode>=nbuttons) endmode=-1;
	        break;
	    }
	  }
	  break;
        case AG_KEYPRESSED:
	  firstkey=false;
	  break;
        case AG_SIZECHANGED:
	  for ( i = 0; i < nbuttons; i++ ) {
	    buts[i]->move( buts[i]->getX(), msg->size.newh - win->getBorderWidth() - buts[i]->getHeight() );
	  }
	  AGUIX::scaleElementsW( msg->size.neww, 10, -1, -1, true, true, (GUIElement**)(&sg), 1 );
	  AGUIX::scaleElementsW( msg->size.neww, 10, 10, -1, false, false, (GUIElement**)buts, nbuttons );
	  break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  *return_str=dupstring(sg->getText());
  win->close();
  delete win;
  for(i=0;i<lines;i++) _freesafe(liness[i]);
  for(i=0;i<nbuttons;i++) _freesafe(buttonss[i]);
  _freesafe(liness);
  _freesafe(buttonss);
  _freesafe(buts);
  return endmode;
}
