/* solidbutton.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: solidbutton.cc,v 1.5 2001/11/03 17:15:55 ralf Exp $ */

#include "solidbutton.h"
#include "lowlevelfunc.h"
#include "awindow.h"

const char *SolidButton::type="SolidButton";

SolidButton::~SolidButton()
{
  if(text!=NULL) _freesafe(text);
}

SolidButton::SolidButton(AGUIX *taguix):GUIElement(taguix)
{
  this->state=false;
  this->text=(char*)_allocsafe(1);
  this->text[0]=0;
  this->fg=0;
  this->bg=0;
  lastbg=-1;
  font=NULL;
}

SolidButton::SolidButton(AGUIX *taguix,int tx,int ty,int width,
                         const char *ttext,int tfg,int tbg,bool tstate):GUIElement(taguix)
{
  this->x=tx;
  this->y=ty;
  this->w=width;
  this->h=taguix->getCharHeight()+4;
  this->state=tstate;
  this->text=dupstring(ttext);
  this->fg=tfg;
  this->bg=tbg;
  lastbg=-1;
  font=NULL;
}

SolidButton::SolidButton(AGUIX *taguix,int tx,int ty,int width,int height,
                         const char *ttext,int tfg,int tbg,bool tstate):GUIElement(taguix)
{
  this->x=tx;
  this->y=ty;
  this->w=width;
  this->h=height;
  this->state=tstate;
  this->text=dupstring(ttext);
  this->fg=tfg;
  this->bg=tbg;
  lastbg=-1;
  font=NULL;
}

const char *SolidButton::getText()
{
  return text;
}

void SolidButton::setText(const char *new_text)
{
  if(text!=NULL) _freesafe(text);
  text=dupstring(new_text);
  redraw();
}

void SolidButton::setFG(int tfg)
{
  if((tfg<(aguix->getMaxCols()))&&(tfg>=0)) {
    this->fg=tfg;
    redraw();
  }
}

int SolidButton::getFG()
{
  return fg;
}

void SolidButton::setBG(int tbg)
{
  if((tbg<(aguix->getMaxCols()))&&(tbg>=0)) {
    this->bg=tbg;
    redraw();
  }
}

int SolidButton::getBG()
{
  return bg;
}

bool SolidButton::getState()
{
  return state;
}

void SolidButton::setState(bool tstate)
{
  this->state=tstate;
  redraw();
}

void SolidButton::redraw()
{
  GC usegc;
  if(parent==NULL) return;
  if(win==0) return;
  aguix->SetWindowBG(win,bg);
  lastbg=bg;
  aguix->ClearWin(win);
  if(font==NULL) usegc=0; else usegc=font->getGC();
  if(state==true) {
    aguix->setFG(usegc,1);
  } else {
    aguix->setFG(usegc,2);
  }
  aguix->DrawLine(win,usegc,0,h-1,0,0);
  aguix->DrawLine(win,usegc,0,0,w-1,0);
  if(state==true) {
    aguix->setFG(usegc,2);
  } else {
    aguix->setFG(usegc,1);
  }
  aguix->DrawLine(win,usegc,0,h-1,w-1,h-1);
  aguix->DrawLine(win,usegc,w-1,h-1,w-1,1);
  aguix->setFG(usegc,fg);
  int ch,cw;
  if(font==NULL) {
    ch=aguix->getCharHeight();
    cw=aguix->getCharWidth();
  } else {
    ch=font->getCharHeight();
    cw=font->getCharWidth();
  }
  int dy=h/2-ch/2;
  unsigned int maxdisplay=(w-2)/cw;
  char *tstr;
  tstr=dupstring(text);
  if(strlen(tstr)>maxdisplay) tstr[maxdisplay]=0;
  int dw=strlen(tstr)*(aguix->getCharWidth());
  int dx=w/2-dw/2;
  if(font==NULL) aguix->DrawText(win,tstr,dx,dy);
  else aguix->DrawText(win,font,tstr,dx,dy);
  _freesafe(tstr);
  aguix->Flush();
}

void SolidButton::flush()
{
}

bool SolidButton::handleMessage(XEvent *E,Message *msg)
{
  if((msg->type==Expose)&&(msg->window==win)) {
    redraw();
  }
  return false;
}

int SolidButton::setFont(char *fontname)
{
  font=aguix->getFont(fontname);
  if(font==NULL) return -1;
  return 0;
}

const char *SolidButton::getType()
{
  return type;
}

bool SolidButton::isType(const char *qtype)
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}
