/* datei.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: datei.h,v 1.27 2002/03/17 01:08:22 ralf Exp $ */

#ifndef DATEI_H
#define DATEI_H

#include "wdefines.h"
#include <aguix/util.h>
#include <aguix/fieldlistview.h>
#include <aguix/fieldlistviewdnd.h>

/* vvv Nur eins davon kann gleichzeitig aktiv sein, also durch numerieren */
enum { SORT_NAME = 0,
       SORT_SIZE,
       SORT_ACCTIME,
       SORT_MODTIME,
       SORT_CHGTIME,
       SORT_TYPE,
       SORT_OWNER };

/* for checking valid sortmode */
#define ISVALID_SORTMODE(sortmode) ( ( ( sortmode & 0xff ) >= SORT_NAME ) && ( ( sortmode & 0xff ) <= SORT_OWNER ) )

/* vvv Dient zur Ver-Oderung mit dem Mode */
#define SORT_REVERSE 256
enum {SORT_DIRLAST=512,SORT_DIRMIXED=1024};


class WCFiletype;

class Datei
{
public:
  Datei();
  ~Datei();
  int open(const char *name,char *mode);
  void close();
  int putUChar(unsigned char value);
  int putUShort(unsigned short int value);
  int putInt(int);
  int putULong(unsigned long value);
  int putString(char *string);
  unsigned char getUChar();
  int getCharAsInt();
  unsigned short int getUShort();
  int getInt();
  unsigned long getULong();
  char *getString(int count);
  int getString(char *,int count);
  void seek(long offset,int mode);
  int overreadChunk();
  long errors();
  int putStringExt(const char *format,const char *str);
  
  static int getIntSize();
  static int getUCharSize();
  static int getUShortSize();
  static int getULongSize();
  static bool fileExists(const char*);
  typedef enum {D_FE_NOFILE,D_FE_FILE,D_FE_DIR,D_FE_LINK} d_fe_t;
  static d_fe_t fileExistsExt(const char*);
  static d_fe_t lfileExistsExt(const char*);
  static char *getFilenameFromPath(const char*);
  static char *getNameWithoutExt(const char*);
  static char *createTMPName();
  static char *shrinkFilename( const char *str, int maxlength );
private:
  FILE *fp;
  long error;
};

class FileEntry
{
public:
  FileEntry();
  ~FileEntry();
  bool isDir();
  FileEntry *duplicate();
  int readInfos();
  int readInfos(bool);
  char *getDestination();
  int writeDestination2Buf(char*,int,bool);
  char *getPermStr();
  char *getSPermStr();
  void writePerm2Buf(char*,bool);
  bool isExe();
  WCFiletype* checkFiletype( List *ftlist, bool skipcontent );
  bool match(char* pattern);
  
  char *fullname;
  char *name;
  loff_t size;                 // Groesse des Eintrages
  loff_t dsize;                // Groesse des Ziel des Eintrages (Bei Links)
  loff_t dirsize;
  bool select;
  time_t lastaccess;
  time_t dlastaccess;
  time_t lastmod;
  time_t dlastmod;
  time_t lastchange;
  time_t dlastchange;
  mode_t mode;
  mode_t dmode;
  bool isLink;
  bool isCorrupt;
  uid_t userid;
  uid_t duserid;
  gid_t groupid;
  gid_t dgroupid;
  long nr;
  bool inFilter;
  WCFiletype *filetype;
  bool isHidden;
  bool use;
};

class Verzeichnis
{
public:
  Verzeichnis();
  ~Verzeichnis();
  ArrayList *getFiles();
  int readDir(const char *);
  void closeDir();
  int sort(int);
  int sort(int,bool force);
  int getSize();
  char *getDir();
  void setLVC4FE( FieldListView *lv, int row,FileEntry*,int*);
  void setLVC4FE_DND( FieldListViewDND *lv, int row,FileEntry*,int*);

  int getUseSize();
  static int sortfunction(void*,void*,int);
  ArrayList *getInvalidEntries();
protected:

  ArrayList *files;
  char *actdir;
  int actsortmode;
  
  ArrayList *invalid_entries;
};

char *ParentDir(const char *,char *);
char *ParentDir(const char *,char *,int);
char *HandlePath(const char *);
char *HandlePathExt(const char*);
int getOwnerStringLen(uid_t,gid_t);
char* getOwnerString(uid_t,gid_t);
char *resolveEnv(const char*);

extern int datelen;

int getDatelen();

#endif

