/* ownop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: ownop.cc,v 1.18 2002/03/18 18:57:49 ralf Exp $ */

#include "ownop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *OwnOp::name="OwnOp";

struct {char *flag;
        int catcode;} flags[]={{"{Rs{Infotext}{Defaulttext}}",0},
                               {"{p}",1},
                               {"{op}",2},
                               {"{lp}",3},
                               {"{rp}",4},
                               {"{dp}",37},
                               {"{f}",5},
                               {"{F}",6},
                               {"{a}",7},
                               {"{A}",8},
                               {"{fE}",9},
                               {"{FE}",10},
                               {"{aE}",11},
                               {"{AE}",12},
                               {"{uf}",13},
                               {"{uF}",14},
                               {"{ua}",15},
                               {"{uA}",16},
                               {"{ufE}",17},
                               {"{uFE}",18},
                               {"{uaE}",19},
                               {"{uAE}",20},
                               {"{of}",21},
                               {"{oF}",22},
                               {"{oa}",23},
                               {"{oA}",24},
                               {"{ofE}",25},
                               {"{oFE}",26},
                               {"{oaE}",27},
                               {"{oAE}",28},
                               {"{ouf}",29},
                               {"{ouF}",30},
                               {"{oua}",31},
                               {"{ouA}",32},
                               {"{oufE}",33},
                               {"{ouFE}",34},
                               {"{ouaE}",35},
                               {"{ouAE}",36}};

OwnOp::OwnOp(Worker *tworker):FunctionProto(tworker)
{
  withapo=false;
  separate_each_entry=false;
  recursive=false;
  inbackground = false;

  ownstart=OWNOP_START_NORMAL;

  com_str=dupstring("");
  view_str=dupstring("");
}

OwnOp::~OwnOp()
{
  _freesafe(com_str);
  _freesafe(view_str);
}

OwnOp*
OwnOp::duplicate()
{
  OwnOp *ta=new OwnOp(worker);
  ta->withapo=withapo;
  ta->separate_each_entry=separate_each_entry;
  ta->recursive=recursive;
  ta->inbackground = inbackground;

  ta->ownstart=ownstart;

  _freesafe(ta->com_str);
  _freesafe(ta->view_str);
  ta->com_str=dupstring(com_str);
  ta->view_str=dupstring(view_str);
  return ta;
}

bool
OwnOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
OwnOp::getName()
{
  return name;
}

int
OwnOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      endlister=worker->getOtherLister(startlister);
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodeown();
    }
  } else normalmodeown();
  return 0;
}

bool
OwnOp::save(Datei *fh)
{
  int size=5*Datei::getUCharSize()+2*Datei::getIntSize();
  size+=strlen(com_str);
  size+=strlen(view_str);
  fh->putInt(size);

  fh->putUChar((withapo==true)?1:0);
  fh->putUChar((separate_each_entry==true)?1:0);
  fh->putUChar((recursive==true)?1:0);
  switch(ownstart) {
    case OWNOP_START_IN_TERMINAL:
      fh->putUChar(1);
      break;
    case OWNOP_START_IN_TERMINAL_AND_WAIT4KEY:
      fh->putUChar(2);
      break;
    case OWNOP_SHOW_OUTPUT:
      fh->putUChar(3);
      break;
    default:
      fh->putUChar(0);
  }
  fh->putInt(strlen(com_str));
  fh->putString(com_str);
  fh->putInt(strlen(view_str));
  fh->putString(view_str);
  
  fh->putUChar( ( inbackground == true ) ? 1 : 0 );
  return true;
}

int
OwnOp::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int cs=Datei::getUCharSize(),
      is=Datei::getIntSize(),
      len;
  unsigned char c1;
  if(chunksize>=(4*cs+2*is)) {
    if(fh->getUChar()==1) withapo=true; else withapo=false;
    if(fh->getUChar()==1) separate_each_entry=true; else separate_each_entry=false;
    if(fh->getUChar()==1) recursive=true; else recursive=false;
    c1=fh->getUChar();
    switch(c1) {
      case 1:
        ownstart=OWNOP_START_IN_TERMINAL;
        break;
      case 2:
        ownstart=OWNOP_START_IN_TERMINAL_AND_WAIT4KEY;
        break;
      case 3:
        ownstart=OWNOP_SHOW_OUTPUT;
        break;
      default:
        ownstart=OWNOP_START_NORMAL;
    }
    chunksize-=4*cs;

    len=fh->getInt();
    chunksize-=is;
    _freesafe(com_str);
    com_str=fh->getString(len);
    if(com_str==NULL) com_str=dupstring("");
    chunksize-=len;

    len=fh->getInt();
    chunksize-=is;
    _freesafe(view_str);
    view_str=fh->getString(len);
    if(view_str==NULL) view_str=dupstring("");
    chunksize-=len;
    
    // new >2.3.1
    if ( chunksize >= cs ) {
      if ( fh->getUChar() == 1 ) inbackground = true; else inbackground = false;
      chunksize -= cs;
    }
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return true;
}

const char *
OwnOp::getDescription()
{
  return catalog.getLocaleCom(28);
}

int
OwnOp::normalmodeown()
{
  struct NM_externorder extorder;
  NormalMode *nm1=NULL,
             *nm2=NULL;
  ListerMode *lm1=NULL;
  struct NM_specialsource *specialsource=NULL;
  
  if(am->mode==am->AM_MODE_DNDACTION) {
    lm1=((DNDMsg*)am->extraInfo)->getSourceMode();
    if(lm1==NULL) return 1;
    if(lm1->isType("NormalMode")!=true) return 1;
    nm1=(NormalMode*)lm1;
    lm1=((DNDMsg*)am->extraInfo)->getDestMode();
    if(lm1!=NULL)
      if(lm1->isType("NormalMode")==true)
        nm2=(NormalMode*)lm1;
  } else {
    if(startlister==NULL) return 1;
    lm1=startlister->getActiveMode();
    if(lm1==NULL) return 1;
    if(lm1->isType("NormalMode")!=true) return 1;
    nm1=(NormalMode*)lm1;
    if(endlister!=NULL) {
      lm1=endlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          nm2=(NormalMode*)lm1;
    }
  }
  
  extorder.destmode=NULL;
  if(am->mode==am->AM_MODE_ONLYACTIVE)
    extorder.source=extorder.NM_ONLYACTIVE;
  else if(am->mode==am->AM_MODE_DNDACTION) {
    // insert DND-element into list
    extorder.source=extorder.NM_SPECIAL;
    extorder.sources=new List;
    specialsource=(struct NM_specialsource*)_allocsafe(sizeof(struct NM_specialsource));
    specialsource->entry=((DNDMsg*)am->extraInfo)->getFE();
    specialsource->row=-1;
    extorder.sources->addElement(specialsource);
    extorder.destmode=nm2;
  } else if(am->mode==am->AM_MODE_SPECIAL) {
    extorder.source=extorder.NM_SPECIAL;
    extorder.sources=new List;
    specialsource=(struct NM_specialsource*)_allocsafe(sizeof(struct NM_specialsource));
    specialsource->entry=(FileEntry*)am->extraInfo;
    specialsource->row=-1;
    extorder.sources->addElement(specialsource);
  } else
    extorder.source=extorder.NM_ALLENTRIES;

  extorder.withapo=withapo;
  extorder.separate_each_entry=separate_each_entry;
  extorder.recursive=recursive;
  extorder.inbackground = inbackground;
  switch(ownstart) {
    case OWNOP_START_IN_TERMINAL:
      extorder.extstart=extorder.NM_EXT_START_IN_TERMINAL;
      break;
    case OWNOP_START_IN_TERMINAL_AND_WAIT4KEY:
      extorder.extstart=extorder.NM_EXT_START_IN_TERMINAL_AND_WAIT4KEY;
      break;
    case OWNOP_SHOW_OUTPUT:
      extorder.extstart=extorder.NM_EXT_SHOW_OUTPUT;
      break;
    default:
      extorder.extstart=extorder.NM_EXT_START_NORMAL;
      break;
  }
  extorder.com_str=NULL;
  extorder.view_str=NULL;
  if(strlen(com_str)>0) extorder.com_str=com_str;
  if(strlen(view_str)>0) extorder.view_str=view_str;
  nm1->externprog(&extorder);

  if(extorder.source==extorder.NM_SPECIAL) {
    if(specialsource!=NULL) _freesafe(specialsource);
    delete extorder.sources;
  }

  return 0;
}

int
OwnOp::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb,*fb;
  StringGadget *sg[2];
  AWindow *win;
  ChooseButton *wacb,*scb,*rcb, *ibcb;
  CycleButton *cyb;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  Requester *req;
  char *textstr,*buttonstr,*tstr;
  int erg;
  
  req=new Requester(aguix);
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(28))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(28));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  wacb=(ChooseButton*)win->add(new ChooseButton(aguix,x,y,(withapo==true)?1:0,
                                                catalog.getLocale(328),LABEL_RIGHT,1,0));
  y+=wacb->getHeight()+5;
  tw=wacb->getWidth()+10;
  if(tw>w) w=tw;

  scb=(ChooseButton*)win->add(new ChooseButton(aguix,x,y,(separate_each_entry==true)?1:0,
                                               catalog.getLocale(329),LABEL_RIGHT,1,0));
  y+=scb->getHeight()+5;
  tw=scb->getWidth()+10;
  if(tw>w) w=tw;

  rcb=(ChooseButton*)win->add(new ChooseButton(aguix,x,y,(recursive==true)?1:0,
                                               catalog.getLocale(330),LABEL_RIGHT,1,0));
  y+=rcb->getHeight()+5;
  tw=rcb->getWidth()+10;
  if(tw>w) w=tw;

  ibcb = (ChooseButton*)win->add( new ChooseButton( aguix,
                                                    x,
                                                    y,
                                                    ( inbackground == true ) ? 1 : 0,
                                                    catalog.getLocale( 435 ),
                                                    LABEL_RIGHT,
                                                    1,
                                                    0 ) );
  y+=ibcb->getHeight()+5;
  tw=ibcb->getWidth()+10;
  if(tw>w) w=tw;

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(331),1));
  x+=ttext->getWidth()+5;
  cyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  cyb->addOption(catalog.getLocale(332));
  cyb->addOption(catalog.getLocale(333));
  cyb->addOption(catalog.getLocale(334));
  cyb->addOption(catalog.getLocale(335));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  switch(ownstart) {
    case OWNOP_START_IN_TERMINAL:
      cyb->setOption(1);
      break;
    case OWNOP_START_IN_TERMINAL_AND_WAIT4KEY:
      cyb->setOption(2);
      break;
    case OWNOP_SHOW_OUTPUT:
      cyb->setOption(3);
      break;
    default:
      cyb->setOption(0);
      break;
  }
  
  y+=cyb->getHeight()+5;
  tw=x+cyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(336),1));
  x+=ttext->getWidth()+5;
  tw=w-x-5;
  if(tw<50) tw=50;
  sg[0]=(StringGadget*)win->add(new StringGadget(aguix,x,y,tw,com_str,0));
  
  fb=(Button*)win->add(new Button(aguix,x+sg[0]->getWidth(),y,sg[0]->getHeight(),
                                  sg[0]->getHeight(),"O",1,0,0));
  
  y+=sg[0]->getHeight()+5;
  tw=sg[0]->getWidth()+5+x;
  if(tw>w) w=tw;
  x=5;
  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(337),1));
  x+=ttext->getWidth()+5;
  tw=w-x-5;
  if(tw<50) tw=50;
  sg[1]=(StringGadget*)win->add(new StringGadget(aguix,x,y,tw,view_str,0));
  y+=sg[1]->getHeight()+5;
  tw=sg[1]->getWidth()+5+x;
  if(tw>w) w=tw;
  x=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  sg[0]->resize(w-5-sg[0]->getX()-sg[0]->getHeight(),sg[0]->getHeight());
  sg[1]->resize(w-5-sg[1]->getX(),sg[1]->getHeight());
  fb->move(w-5-fb->getWidth(),fb->getY());

  h=y;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) {
            if(NormalMode::isCorrectViewProg(sg[1]->getText())==false) {
              // show requester
              textstr=catalog.getLocale(312);
              buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                          strlen(catalog.getLocale(314))+1);
              sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                        catalog.getLocale(314));
              erg=req->request(catalog.getLocale(125),textstr,buttonstr);
              _freesafe(buttonstr);
              if(erg==0) {
                sg[0]->deactivate();
                sg[1]->activate();
              } else {
                sg[1]->setText("");
              }
            } else endmode=0;
          } else if(msg->button.button==cb) endmode=1;
          else if(msg->button.button==fb) {
            tstr=getFlag();
            if(tstr!=NULL) {
              const char *newstr1=sg[0]->getText();
              char *newstr2;
              int pos=sg[0]->getCursor();
              newstr2=(char*)_allocsafe(strlen(newstr1)+strlen(tstr)+1);
              strncpy(newstr2,newstr1,pos);
              strcpy(newstr2+pos,tstr);
              strcpy(newstr2+pos+strlen(tstr),newstr1+pos);
              sg[0]->setText(newstr2);
              _freesafe(newstr2);
              _freesafe(tstr);
            }
          }
          break;
	case AG_STRINGGADGET_DEACTIVATE:
          if(msg->stringgadget.sg==sg[1]) {
            if(NormalMode::isCorrectViewProg(sg[1]->getText())==false) {
              // show requester
              textstr=catalog.getLocale(312);
              buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                          strlen(catalog.getLocale(314))+1);
              sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                        catalog.getLocale(314));
              erg=req->request(catalog.getLocale(125),textstr,buttonstr);
              _freesafe(buttonstr);
              if(erg==0) {
                sg[0]->deactivate();
                sg[1]->activate();
              } else {
                sg[1]->setText("");
              }
            }
          }
	  break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    withapo=(wacb->getState()==1)?true:false;
    separate_each_entry=(scb->getState()==1)?true:false;
    recursive=(rcb->getState()==1)?true:false;
    inbackground = ( ibcb->getState() == 1 ) ? true : false;
    _freesafe(com_str);
    _freesafe(view_str);
    com_str=dupstring(sg[0]->getText());
    view_str=dupstring(sg[1]->getText());
    switch(cyb->getSelectedOption()) {
      case 1:
        ownstart=OWNOP_START_IN_TERMINAL;
        break;
      case 2:
        ownstart=OWNOP_START_IN_TERMINAL_AND_WAIT4KEY;
        break;
      case 3:
        ownstart=OWNOP_SHOW_OUTPUT;
        break;
      default:
        ownstart=OWNOP_START_NORMAL;
        break;
    }
  }
  
  win->close();
  delete win;
  delete req;

  return endmode;
}

char*
OwnOp::getFlag()
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  FieldListView *lv;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *returnstr;
  Button *b2[2];
  int i, trow;
  
  w=400;
  h=300;
  x=y=5;
  win=new AWindow(aguix);
  win->create(NULL,10,10,w,h,0,catalog.getLocale(338));

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(338),1));
  y+=ttext->getHeight()+5;

  lv = (FieldListView*)win->add( new FieldListView( aguix,
                                                    x,
                                                    y,
                                                    w - 2 * x,
                                                    200,
                                                    0 ) );
  y+=lv->getHeight()+5;
  lv->setHBarState(2);
  lv->setVBarState(2);

  lv->setNrOfFields( 3 );
  lv->setFieldWidth( 1, 3 );
  
  for( i=0;i<CATFLAGENTRY;i++) {
    trow = lv->addRow();
    lv->setText( trow, 0, flags[ i ].flag );
    lv->setText( trow, 2, catalog.getLocaleFlag( flags[ i ].catcode ) );
    lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    lv->setData( trow, i );
  }

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;

  b2[0] = okb;
  b2[1] = cb;
  
  h=y;
  win->resize(w,h);
  //win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
        case AG_SIZECHANGED:
          AGUIX::scaleElementsW( msg->size.neww, 5, 10, -1, false, false, (GUIElement**)b2, 2 );
          for ( i = 0; i < 2; i++ ) {
            b2[i]->move( b2[i]->getX(), msg->size.newh - 5 - b2[i]->getHeight() );
          }
          lv->resize( msg->size.neww - 10, b2[0]->getY() - 5 - lv->getY() );
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  returnstr=NULL;
  if(endmode==0) {
    // ok
    trow = lv->getActiveRow();
    if ( lv->isValidRow( trow ) == true ) {
      int nr = lv->getData( trow );
      returnstr = dupstring( flags[nr].flag );
    }
  }
  
  win->close();
  delete win;

  return returnstr;
}

void OwnOp::setWithApo(bool nv)
{
  withapo=nv;
}

void OwnOp::setSeparateEachEntry(bool nv)
{
  separate_each_entry=nv;
}

void OwnOp::setRecursive(bool nv)
{
  recursive=nv;
}

void OwnOp::setOwnStart(ownstart_t nv)
{
  ownstart=nv;
}

void OwnOp::setComStr(const char* nv)
{
  _freesafe(com_str);
  com_str=dupstring(nv);
}

void OwnOp::setInBackground( bool nv )
{
  inbackground = nv;
}

