/* partspace.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: partspace.h,v 1.5 2002/03/08 19:47:53 ralf Exp $ */

#ifndef PARTSPACE_H
#define PARTSPACE_H

#include <aguix/lowlevelfunc.h>
#include <aguix/util.h>
#include "wdefines.h"

#ifdef WANT_THREADS  
#include <aguix/mutex.h>
#include <aguix/condvar.h>
#endif

#define PARTSPACE_INFO_LIFETIME 10.0

class PartSpace
{
public:
  PartSpace();
  ~PartSpace();
  int readSpace( const char*name );
  
  long getBlocksize();
  long getFreeSpace();
  long getSpace();
  
  long getFreeSpaceH(char **unit_return);
  long getSpaceH(char **unit_return);

#ifdef WANT_THREADS  
  void slavehandler();
#endif
protected:
  long blocksize;
  long freespace;
  long space;
  
#ifdef WANT_THREADS  
  struct {
    int running;
    bool stop;
    pthread_t th;
    
    CondVar waitvar;
  } slave;
#endif
  bool thread_usage;

#ifdef WANT_THREADS  
  class SpaceRequestList
  {
  public:
    typedef struct _space_request_list_t {
      char *name;
#ifdef HAVE_SYS_STATVFS_H
      struct statvfs fsstatistic;
#else
      struct statfs fsstatistic;
#endif
      int error;
      time_t readtime;
      struct _space_request_list_t *next;
    } space_request_list_t;

    SpaceRequestList();
    ~SpaceRequestList();

    bool isEmpty_locked();
    int put_locked( space_request_list_t *elem );
    space_request_list_t *remove_locked();

    void lock();
    void unlock();
    void wait();
    void signal();
  protected:
    CondVar ex;
    space_request_list_t *head, *tail;
    int elements;
  };

  SpaceRequestList *spacerequest;
  SpaceRequestList *spaceanswer;
#endif

#ifdef HAVE_SYS_STATVFS_H
  int getSpace( const char *name, struct statvfs *statbuf );
#else
  int getSpace( const char *name, struct statfs *statbuf );
#endif

#ifdef WANT_THREADS  
  List *spaceinfo;
#endif
};

#endif

