/* worker_commands.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: worker_commands.cc,v 1.19 2001/12/11 23:16:49 ralf Exp $ */

#include "worker.h"
#include "worker_commands.h"

int Worker::getNrOfCommands()
{
  return CATCOMENTRY;
}

FunctionProto *Worker::getCommand4ID(int id)
{
  FunctionProto *fpr=NULL;
  switch(id) {
    case 1:fpr=new DoubleClickAction(this);
      break;
    case 2:fpr=new ShowAction(this);
      break;
    case 3:fpr=new RawShowAction(this);
      break;
    case 4:fpr=new UserAction(this);
      break;
    case 5:
      fpr=new RowUp(this);
      break;
    case 6:
      fpr=new RowDown(this);
      break;
    case 7:
      fpr=new ChangeHiddenFlag(this);
      break;
    case 8:
      fpr=new CopyOp(this);
      break;
    case 9:
      fpr=new FirstRow(this);
      break;
    case 10:
      fpr=new LastRow(this);
      break;
    case 11:
      fpr=new PageUp(this);
      break;
    case 12:
      fpr=new PageDown(this);
      break;
    case 13:
      fpr=new SelectOp(this);
      break;
    case 14:
      fpr=new SelectAllOp(this);
      break;
    case 15:
      fpr=new SelectNoneOp(this);
      break;
    case 16:
      fpr=new InvertAllOp(this);
      break;
    case 17:
      fpr=new ParentDirOp(this);
      break;
    case 18:
      fpr=new EnterDirOp(this);
      break;
    case 19:
      fpr=new ChangeListerSetOp(this);
      break;
    case 20:
      fpr=new SwitchListerOp(this);
      break;
    case 21:
      fpr=new FilterSelectOp(this);
      break;
    case 22:
      fpr=new FilterUnSelectOp(this);
      break;
    case 23:
      fpr=new Path2OSideOp(this);
      break;
    case 24:
      fpr=new QuitOp(this);
      break;
    case 25:
      fpr=new DeleteOp(this);
      break;
    case 26:
      fpr=new ReloadOp(this);
      break;
    case 27:
      fpr=new MakeDirOp(this);
      break;
    case 28:
      fpr=new OwnOp(this);
      break;
    case 29:
      fpr=new RenameOp(this);
      break;
    case 30:
      fpr=new DirSizeOp(this);
      break;
    case 31:
      fpr=new SimDDOp(this);
      break;
    case 32:
      fpr=new StartProgOp(this);
      break;
    case 33:
      fpr=new SearchEntryOp(this);
      break;
    case 34:
      fpr=new EnterPathOp(this);
      break;
    case 35:
      fpr=new ScrollListerOp(this);
      break;
    case 36:
      fpr=new CreateSymlinkOp(this);
      break;
    case 37:
      fpr=new ChangeSymlinkOp(this);
      break;
    case 38:
      fpr=new ChModOp(this);
      break;
    case 39:
      fpr=new ToggleListermodeOp(this);
      break;
    case 40:
      fpr=new SetSortmodeOp(this);
      break;
    case 41:
      fpr=new SetFilterOp(this);
      break;
    case 42:
      fpr=new ShortkeyFromListOp(this);
      break;
    default:
      fpr=new DNDAction(this);
  }
  return fpr;
}

int Worker::getID4Command(FunctionProto *fpr)
{
  int type=-1;
  if(fpr->isName("DNDAction")==true) type=0;
  else if(fpr->isName("DoubleClickAction")==true) type=1;
  else if(fpr->isName("ShowAction")==true) type=2;
  else if(fpr->isName("RawShowAction")==true) type=3;
  else if(fpr->isName("UserAction")==true) type=4;
  else if(fpr->isName("RowUp")==true) type=5;
  else if(fpr->isName("RowDown")==true) type=6;
  else if(fpr->isName("ChangeHiddenFlag")==true) type=7;
  else if(fpr->isName("CopyOp")==true) type=8;
  else if(fpr->isName("FirstRow")==true) type=9;
  else if(fpr->isName("LastRow")==true) type=10;
  else if(fpr->isName("PageUp")==true) type=11;
  else if(fpr->isName("PageDown")==true) type=12;
  else if(fpr->isName("SelectOp")==true) type=13;
  else if(fpr->isName("SelectAllOp")==true) type=14;
  else if(fpr->isName("SelectNoneOp")==true) type=15;
  else if(fpr->isName("InvertAllOp")==true) type=16;
  else if(fpr->isName("ParentDirOp")==true) type=17;
  else if(fpr->isName("EnterDirOp")==true) type=18;
  else if(fpr->isName("ChangeListerSetOp")==true) type=19;
  else if(fpr->isName("SwitchListerOp")==true) type=20;
  else if(fpr->isName("FilterSelectOp")==true) type=21;
  else if(fpr->isName("FilterUnSelectOp")==true) type=22;
  else if(fpr->isName("Path2OSideOp")==true) type=23;
  else if(fpr->isName("QuitOp")==true) type=24;
  else if(fpr->isName("DeleteOp")==true) type=25;
  else if(fpr->isName("ReloadOp")==true) type=26;
  else if(fpr->isName("MakeDirOp")==true) type=27;
  else if(fpr->isName("OwnOp")==true) type=28;
  else if(fpr->isName("RenameOp")==true) type=29;
  else if(fpr->isName("DirSizeOp")==true) type=30;
  else if(fpr->isName("SimDDOp")==true) type=31;
  else if(fpr->isName("StartProgOp")==true) type=32;
  else if(fpr->isName("SearchEntryOp")==true) type=33;
  else if(fpr->isName("EnterPathOp")==true) type=34;
  else if(fpr->isName("ScrollListerOp")==true) type=35;
  else if(fpr->isName("CreateSymlinkOp")==true) type=36;
  else if(fpr->isName("ChangeSymlinkOp")==true) type=37;
  else if(fpr->isName("ChModOp")==true) type=38;
  else if(fpr->isName("ToggleListermodeOp")==true) type=39;
  else if(fpr->isName("SetSortmodeOp")==true) type=40;
  else if(fpr->isName("SetFilterOp")==true) type=41;
  else if(fpr->isName("ShortkeyFromListOp")==true) type=42;
  return type;
}

