/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "Correlation.h"
#include "Exception.h"

#include <cmath>
using namespace std;

CCorrelation::CCorrelation() :
m_product(0.0),
m_divisorA(0.0),
m_divisorB(0.0),
m_count(0)
{
}

CCorrelation::~CCorrelation()
{
}

void CCorrelation::clear()
{
	m_product = 0.0;
	m_divisorA = 0.0;
	m_divisorB = 0.0;
	m_count = 0;
}

void CCorrelation::addProduct(double a, double b)
{
	m_product += a * b;

	m_divisorA += a * a;
	m_divisorB += b * b;

	m_count++;
}

bool CCorrelation::getRawValue(double& value) const
{
	value = m_product;

	return (m_product > 0.0);
}

bool CCorrelation::getNormalisedValue(double& value) const
{
	if (m_product <= 0.0) {
		value = m_product;
		return false;
	}

	double square = ::sqrt(m_divisorA * m_divisorB);

	if (m_count == 0 || square == 0.0)
		throw CException(wxT("Divide by zero in Correlator"));

	value = m_product / square;

	return true;
}
