/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExpression;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.SingletonNodeSet;
import org.xml.sax.SAXException;

public class NodeListExpression
extends NodeSetExpression {
    private Expression baseExpression;

    public NodeListExpression(Expression expression) {
        this.baseExpression = expression;
    }

    public Expression simplify() throws SAXException {
        this.baseExpression = this.baseExpression.simplify();
        if (this.baseExpression instanceof EmptyNodeSet) {
            return this.baseExpression;
        }
        if (this.baseExpression instanceof SingletonNodeSet) {
            return this.baseExpression;
        }
        return this;
    }

    public int getDependencies() {
        return this.baseExpression.getDependencies();
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((this.getDependencies() & n) != 0) {
            return new NodeListExpression(this.baseExpression.reduce(n, context));
        }
        return this;
    }

    public NodeEnumeration enumerate(Context context) throws SAXException {
        NodeEnumeration nodeEnumeration = this.baseExpression.enumerate(context);
        if (nodeEnumeration.isSorted()) {
            return nodeEnumeration;
        }
        NodeSetExtent nodeSetExtent = new NodeSetExtent(nodeEnumeration);
        nodeSetExtent.sort();
        return nodeSetExtent.enumerate();
    }

    public String toString() {
        return this.baseExpression.toString();
    }
}

