/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Bindery;
import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.Name;
import com.icl.saxon.style.XSLGeneralVariable;
import com.icl.saxon.trace.TraceListener;
import org.xml.sax.SAXException;

public class VariableReference
extends Expression {
    private Name fullname;
    private Binding binding;

    public VariableReference(Name name, StaticContext staticContext) throws SAXException {
        this.fullname = name;
        this.binding = staticContext.bindVariable(name.getAbsoluteName());
    }

    public int getDependencies() {
        return 1;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((n & 1) != 0) {
            return this.evaluate(context);
        }
        return this;
    }

    public Value evaluate(Context context) throws SAXException {
        Bindery bindery = context.getBindery();
        Value value = bindery.getValue(this.binding);
        if (value == null) {
            if (!this.binding.isGlobal()) {
                throw new SAXException("Variable " + this.fullname.getDisplayName() + " is undefined");
            }
            bindery.setExecuting(this.binding, true);
            if (this.binding instanceof XSLGeneralVariable) {
                if (context.getController().isTracing()) {
                    TraceListener traceListener = context.getController().getTraceListener();
                    traceListener.enter((XSLGeneralVariable)((Object)this.binding), context);
                    ((XSLGeneralVariable)((Object)this.binding)).process(context);
                    traceListener.leave((XSLGeneralVariable)((Object)this.binding), context);
                } else {
                    ((XSLGeneralVariable)((Object)this.binding)).process(context);
                }
            }
            bindery.setExecuting(this.binding, false);
            value = bindery.getValue(this.binding);
            if (value == null) {
                throw new SAXException("Variable " + this.fullname.getDisplayName() + " is undefined");
            }
        }
        return value;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public String toString() {
        return "$" + this.fullname.getDisplayName();
    }

    public int getDataType() {
        return this.binding.getDataType();
    }

    public Expression simplify() {
        Value value = this.binding.constantValue();
        if (value == null) {
            return this;
        }
        return value;
    }
}

