/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.ProxyEmitter;
import com.icl.saxon.sort.HashMap;
import org.xml.sax.SAXException;

public class HTMLIndenter
extends ProxyEmitter {
    private int level = 0;
    private int indentSpaces = 3;
    private String indentChars = "                                                          ";
    private boolean sameLine = false;
    private boolean isInlineTag = false;
    private boolean isFormattedTag = false;
    private boolean afterInline = false;
    private boolean afterFormatted = true;
    private static String[] inlineTags = new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe", "input", "select", "textarea", "label", "button"};
    private static HashMap inlineTable = new HashMap(203);
    private static HashMap formattedTable;

    private static boolean isInline(String string) {
        return inlineTable.get(string);
    }

    private static boolean isFormatted(String string) {
        return formattedTable.get(string);
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.indentSpaces = this.outputDetails.getIndentSpaces();
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        String string = name.getDisplayName();
        this.isInlineTag = HTMLIndenter.isInline(string);
        this.isFormattedTag = HTMLIndenter.isFormatted(string);
        if (!(this.isInlineTag || this.isFormattedTag || this.afterInline || this.afterFormatted)) {
            this.indent();
        }
        this.isFormattedTag = HTMLIndenter.isFormatted(string);
        super.startElement(name, attributeCollection);
        ++this.level;
        this.sameLine = true;
        this.afterInline = false;
        this.afterFormatted = false;
    }

    public void endElement(Name name) throws SAXException {
        --this.level;
        String string = name.getDisplayName();
        boolean bl = HTMLIndenter.isInline(string);
        boolean bl2 = HTMLIndenter.isFormatted(string);
        if (!(bl || bl2 || this.afterInline || this.sameLine || this.afterFormatted)) {
            this.indent();
            this.afterInline = false;
            this.afterFormatted = false;
        } else {
            this.afterInline = bl;
            this.afterFormatted = bl2;
        }
        super.endElement(name);
        this.isFormattedTag = false;
        this.sameLine = false;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        super.processingInstruction(string, string2);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isFormattedTag) {
            super.characters(cArray, n, n2);
        } else {
            int n3 = n;
            int n4 = n;
            while (n4 < n + n2) {
                if (cArray[n4] == '\n' || n4 - n3 > 120 && cArray[n4] == ' ') {
                    this.sameLine = false;
                    super.characters(cArray, n3, n4 - n3);
                    this.indent();
                    n3 = n4 + 1;
                    while (n3 < n2 && cArray[n3] == ' ') {
                        ++n3;
                    }
                }
                ++n4;
            }
            if (n3 < n + n2) {
                super.characters(cArray, n3, n + n2 - n3);
            }
        }
        this.afterInline = false;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.indent();
        super.comment(cArray, n, n2);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }

    private void indent() throws SAXException {
        int n = this.level * this.indentSpaces;
        while (n > this.indentChars.length()) {
            this.indentChars = this.indentChars + this.indentChars;
        }
        char[] cArray = new char[n + 1];
        cArray[0] = 10;
        this.indentChars.getChars(0, n, cArray, 1);
        super.characters(cArray, 0, n + 1);
        this.sameLine = false;
    }

    static {
        int n = 0;
        while (n < inlineTags.length) {
            inlineTable.set(inlineTags[n]);
            ++n;
        }
        formattedTable = new HashMap(51);
        formattedTable.set("pre");
        formattedTable.set("script");
        formattedTable.set("style");
        formattedTable.set("textarea");
        formattedTable.set("xmp");
    }
}

