/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.LastPositionFinder;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeListExpression;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.GroupActivation;
import com.icl.saxon.style.SAXONItem;
import com.icl.saxon.style.XSLForEach;
import java.util.Stack;
import org.xml.sax.SAXException;

public class SAXONGroup
extends XSLForEach {
    Expression groupBy = null;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        this.checkAllowedAttributes();
        String string = this.getAttributeValue("select");
        if (string == null) {
            this.reportAbsence("select");
        } else {
            this.select = new NodeListExpression(Expression.make(string, this));
        }
        String string2 = this.getAttributeValue("group-by");
        if (string2 == null) {
            this.reportAbsence("group-by");
        } else {
            this.groupBy = Expression.make(string2, this);
        }
    }

    protected void checkAllowedAttributes() throws SAXException {
        String[] stringArray = new String[]{"select", "group-by"};
        this.allowAttributes(stringArray);
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
        this.select = this.handleSortKeys(this.select);
        NodeInfo nodeInfo = this;
        SAXONItem sAXONItem = null;
        while (nodeInfo != null) {
            if (nodeInfo instanceof SAXONItem) {
                sAXONItem = (SAXONItem)nodeInfo;
                break;
            }
            nodeInfo = nodeInfo.getNextInDocument(this);
        }
        if (sAXONItem == null) {
            throw new SAXException("saxon:group must have a nested saxon:item element");
        }
    }

    public void process(Context context) throws SAXException {
        NodeSetValue nodeSetValue = this.select.evaluateAsNodeSet(context);
        NodeEnumeration nodeEnumeration = nodeSetValue.enumerate();
        if (!(nodeEnumeration instanceof LastPositionFinder)) {
            nodeEnumeration = new LookaheadEnumerator(nodeEnumeration);
        }
        Context context2 = context.newContext();
        context2.setLastPositionFinder((LastPositionFinder)((Object)nodeEnumeration));
        GroupActivation groupActivation = new GroupActivation(this, this.groupBy, nodeEnumeration, context2);
        Stack stack = context2.getGroupActivationStack();
        stack.push(groupActivation);
        while (groupActivation.hasMoreElements()) {
            groupActivation.nextElement();
            this.processChildren(context2);
        }
        stack.pop();
    }
}

