/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.Context;
import com.icl.saxon.om.AttributeInfo;
import com.icl.saxon.om.CommentInfo;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.NamespaceInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.ProcInstInfo;
import com.icl.saxon.om.TextInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StyleElement;
import org.xml.sax.SAXException;

public class XSLCopy
extends StyleElement {
    private String use;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"use-attribute-sets"};
        this.allowAttributes(stringArray);
        AttributeCollection attributeCollection = this.attributeList;
        this.use = attributeCollection.getValue("use-attribute-sets");
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
        if (this.use != null) {
            this.findAttributeSets(this.use);
        }
    }

    public void process(Context context) throws SAXException {
        NodeInfo nodeInfo = context.getCurrentNode();
        Outputter outputter = context.getOutputter();
        if (nodeInfo instanceof ElementInfo) {
            outputter.writeStartTag(nodeInfo.getExpandedName());
            ((ElementInfo)nodeInfo).outputNamespaceNodes(outputter);
            this.processAttributeSets(context);
            this.processChildren(context);
            outputter.writeEndTag(nodeInfo.getExpandedName());
        } else if (nodeInfo instanceof AttributeInfo) {
            outputter.writeAttribute(nodeInfo.getExpandedName(), nodeInfo.getValue(), false);
            this.processChildren(context);
        } else if (nodeInfo instanceof TextInfo) {
            outputter.writeContent(nodeInfo.getValue());
            this.processChildren(context);
        } else if (nodeInfo instanceof ProcInstInfo) {
            outputter.writePI(nodeInfo.getDisplayName(), nodeInfo.getValue());
            this.processChildren(context);
        } else if (nodeInfo instanceof CommentInfo) {
            outputter.writeComment(nodeInfo.getValue());
            this.processChildren(context);
        } else if (nodeInfo instanceof NamespaceInfo) {
            NamespaceInfo namespaceInfo = (NamespaceInfo)nodeInfo;
            outputter.writeNamespaceDeclaration(namespaceInfo.getNamespacePrefix(), namespaceInfo.getNamespaceURI(), true);
            this.processChildren(context);
        } else if (nodeInfo instanceof DocumentInfo) {
            this.processChildren(context);
        }
    }
}

