/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.Name;
import com.icl.saxon.style.StyleElement;
import org.xml.sax.SAXException;

public class XSLProcessingInstruction
extends StyleElement {
    Expression name;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"name"};
        this.allowAttributes(stringArray);
        String string = this.getAttributeValue("name");
        if (string == null) {
            this.reportAbsence("name");
        } else {
            this.name = AttributeValueTemplate.make(string, this);
        }
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws SAXException {
        String string = this.name.evaluateAsString(context);
        if (!Name.isNCName(string) || string.equalsIgnoreCase("xml")) {
            context.getController().reportRecoverableError("Processing instruction name is invalid: " + string, this);
            return;
        }
        String string2 = this.expandChildren(context);
        int n = string2.indexOf("?>");
        if (n >= 0) {
            context.getController().reportRecoverableError("Invalid characters (?>) in processing instruction", this);
            string2 = string2.substring(0, n + 1) + " " + string2.substring(n + 1);
        }
        context.getOutputter().writePI(string, string2);
    }
}

